/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.metric;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import no.finn.unleash.metric.ToggleCount;

class MetricsBucket {
    private final Map<String, ToggleCount> toggles;
    private final LocalDateTime start = LocalDateTime.now(ZoneId.of("UTC"));
    private LocalDateTime stop;

    MetricsBucket() {
        this.toggles = new HashMap<String, ToggleCount>();
    }

    void registerCount(String toggleName, boolean active) {
        if (this.toggles.containsKey(toggleName)) {
            this.toggles.get(toggleName).register(active);
        } else {
            ToggleCount counter = new ToggleCount();
            counter.register(active);
            this.toggles.put(toggleName, counter);
        }
    }

    void end() {
        this.stop = LocalDateTime.now(ZoneId.of("UTC"));
    }

    public Map<String, ToggleCount> getToggles() {
        return this.toggles;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public LocalDateTime getStop() {
        return this.stop;
    }
}

