/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.metric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import no.finn.unleash.UnleashException;
import no.finn.unleash.metric.ClientMetrics;
import no.finn.unleash.metric.ClientRegistration;
import no.finn.unleash.util.UnleashConfig;
import no.finn.unleash.util.UnleashURLs;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UnleashMetricsSender {
    private static final Logger LOG = LogManager.getLogger();
    private static final int CONNECT_TIMEOUT = 1000;
    private final Gson gson;
    private UnleashConfig unleashConfig;
    private final URL clientRegistrationURL;
    private final URL clientMetricsURL;

    public UnleashMetricsSender(UnleashConfig unleashConfig) {
        this.unleashConfig = unleashConfig;
        UnleashURLs urls = unleashConfig.getUnleashURLs();
        this.clientMetricsURL = urls.getClientMetricsURL();
        this.clientRegistrationURL = urls.getClientRegisterURL();
        this.gson = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)new DateTimeSerializer()).create();
    }

    public void registerClient(ClientRegistration registration) {
        if (!this.unleashConfig.isDisableMetrics()) {
            try {
                this.post(this.clientRegistrationURL, registration);
            }
            catch (UnleashException ex) {
                LOG.warn("failed to register client", (Throwable)ex);
            }
        }
    }

    public void sendMetrics(ClientMetrics metrics) {
        if (!this.unleashConfig.isDisableMetrics()) {
            try {
                this.post(this.clientMetricsURL, metrics);
            }
            catch (UnleashException ex) {
                LOG.warn("failed to send metrics", (Throwable)ex);
            }
        }
    }

    private int post(URL url, Object o) throws UnleashException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(1000);
            connection.setReadTimeout(1000);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("UNLEASH-APPNAME", this.unleashConfig.getAppName());
            connection.setRequestProperty("UNLEASH-INSTANCEID", this.unleashConfig.getInstanceId());
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(connection.getOutputStream());
            this.gson.toJson(o, (Appendable)wr);
            wr.flush();
            wr.close();
            connection.connect();
            int n = connection.getResponseCode();
            return n;
        }
        catch (IOException e) {
            throw new UnleashException("Could not post to Unleash API", e);
        }
        catch (IllegalStateException e) {
            throw new UnleashException(e.getMessage(), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    static class DateTimeSerializer
    implements JsonSerializer<LocalDateTime> {
        DateTimeSerializer() {
        }

        public JsonElement serialize(LocalDateTime localDateTime, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(DateTimeFormatter.ISO_INSTANT.format(localDateTime.toInstant(ZoneOffset.UTC)));
        }
    }
}

