/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.repository;

import no.finn.unleash.FeatureToggle;
import no.finn.unleash.UnleashException;
import no.finn.unleash.repository.FeatureToggleResponse;
import no.finn.unleash.repository.ToggleBackupHandler;
import no.finn.unleash.repository.ToggleCollection;
import no.finn.unleash.repository.ToggleFetcher;
import no.finn.unleash.repository.ToggleRepository;
import no.finn.unleash.util.UnleashConfig;
import no.finn.unleash.util.UnleashScheduledExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FeatureToggleRepository
implements ToggleRepository {
    private static final Logger LOG = LogManager.getLogger();
    private final ToggleBackupHandler toggleBackupHandler;
    private final ToggleFetcher toggleFetcher;
    private ToggleCollection toggleCollection;

    public FeatureToggleRepository(UnleashConfig unleashConfig, UnleashScheduledExecutor executor, ToggleFetcher toggleFetcher, ToggleBackupHandler toggleBackupHandler) {
        this.toggleBackupHandler = toggleBackupHandler;
        this.toggleFetcher = toggleFetcher;
        this.toggleCollection = toggleBackupHandler.read();
        executor.setInterval(this.updateToggles(), 0L, unleashConfig.getFetchTogglesInterval());
    }

    private Runnable updateToggles() {
        return () -> {
            try {
                FeatureToggleResponse response = this.toggleFetcher.fetchToggles();
                if (response.getStatus() == FeatureToggleResponse.Status.CHANGED) {
                    this.toggleCollection = response.getToggleCollection();
                    this.toggleBackupHandler.write(response.getToggleCollection());
                }
            }
            catch (UnleashException e) {
                LOG.warn("Could not refresh feature toggles", (Throwable)e);
            }
        };
    }

    @Override
    public FeatureToggle getToggle(String name) {
        return this.toggleCollection.getToggle(name);
    }
}

