/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.repository;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import no.finn.unleash.UnleashException;
import no.finn.unleash.repository.FeatureToggleResponse;
import no.finn.unleash.repository.JsonToggleParser;
import no.finn.unleash.repository.ToggleCollection;
import no.finn.unleash.repository.ToggleFetcher;
import no.finn.unleash.util.UnleashConfig;

public final class HttpToggleFetcher
implements ToggleFetcher {
    public static final int CONNECT_TIMEOUT = 10000;
    private String etag = "";
    private final URL toggleUrl;
    private UnleashConfig unleashConfig;

    public HttpToggleFetcher(UnleashConfig unleashConfig) {
        this.unleashConfig = unleashConfig;
        this.toggleUrl = unleashConfig.getUnleashURLs().getFetchTogglesURL();
    }

    @Override
    public FeatureToggleResponse fetchToggles() throws UnleashException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)this.toggleUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("UNLEASH-APPNAME", this.unleashConfig.getAppName());
            connection.setRequestProperty("UNLEASH-INSTANCEID", this.unleashConfig.getInstanceId());
            connection.setRequestProperty("If-None-Match", this.etag);
            connection.setUseCaches(true);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode < 300) {
                FeatureToggleResponse featureToggleResponse = this.getToggleResponse(connection);
                return featureToggleResponse;
            }
            FeatureToggleResponse featureToggleResponse = new FeatureToggleResponse(FeatureToggleResponse.Status.NOT_CHANGED);
            return featureToggleResponse;
        }
        catch (IOException e) {
            throw new UnleashException("Could not fetch toggles", e);
        }
        catch (IllegalStateException e) {
            throw new UnleashException(e.getMessage(), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private FeatureToggleResponse getToggleResponse(HttpURLConnection request) throws IOException {
        this.etag = request.getHeaderField("ETag");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getContent(), StandardCharsets.UTF_8));){
            ToggleCollection toggles = JsonToggleParser.fromJson(reader);
            FeatureToggleResponse featureToggleResponse = new FeatureToggleResponse(FeatureToggleResponse.Status.CHANGED, toggles);
            return featureToggleResponse;
        }
    }
}

