/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import no.finn.unleash.FeatureToggle;

final class ToggleCollection {
    private final Collection<FeatureToggle> features;
    private final int version = 1;
    private final transient Map<String, FeatureToggle> cache;

    ToggleCollection(Collection<FeatureToggle> features) {
        this.features = this.ensureNotNull(features);
        this.cache = new HashMap<String, FeatureToggle>();
        for (FeatureToggle featureToggle : this.features) {
            this.cache.put(featureToggle.getName(), featureToggle);
        }
    }

    private Collection<FeatureToggle> ensureNotNull(Collection<FeatureToggle> features) {
        if (features == null) {
            return Collections.emptyList();
        }
        return features;
    }

    Collection<FeatureToggle> getFeatures() {
        return this.features;
    }

    FeatureToggle getToggle(String name) {
        return this.cache.get(name);
    }
}

