/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.util;

import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import no.finn.unleash.UnleashContextProvider;
import no.finn.unleash.util.UnleashURLs;

public class UnleashConfig {
    private final URI unleashAPI;
    private final UnleashURLs unleashURLs;
    private final String appName;
    private final String instanceId;
    private final String backupFile;
    private final long fetchTogglesInterval;
    private final long sendMetricsInterval;
    private final boolean disableMetrics;
    private final UnleashContextProvider contextProvider;

    public UnleashConfig(URI unleashAPI, String appName, String instanceId, String backupFile, long fetchTogglesInterval, long sendMetricsInterval, boolean disableMetrics, UnleashContextProvider contextProvider) {
        if (appName == null) {
            throw new IllegalStateException("You are required to specify the unleash appName");
        }
        if (unleashAPI == null) {
            throw new IllegalStateException("You are required to specify the unleashAPI url");
        }
        this.unleashAPI = unleashAPI;
        this.unleashURLs = new UnleashURLs(unleashAPI);
        this.appName = appName;
        this.instanceId = instanceId;
        this.backupFile = backupFile;
        this.fetchTogglesInterval = fetchTogglesInterval;
        this.sendMetricsInterval = sendMetricsInterval;
        this.disableMetrics = disableMetrics;
        this.contextProvider = contextProvider;
    }

    public URI getUnleashAPI() {
        return this.unleashAPI;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public long getFetchTogglesInterval() {
        return this.fetchTogglesInterval;
    }

    public long getSendMetricsInterval() {
        return this.sendMetricsInterval;
    }

    public UnleashURLs getUnleashURLs() {
        return this.unleashURLs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isDisableMetrics() {
        return this.disableMetrics;
    }

    public String getBackupFile() {
        return this.backupFile;
    }

    public UnleashContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public static class Builder {
        private URI unleashAPI;
        private String appName;
        private String instanceId = Builder.getDefaultInstanceId();
        private String backupFile;
        private long fetchTogglesInterval = 10L;
        private long sendMetricsInterval = 60L;
        private boolean disableMetrics = false;
        private UnleashContextProvider contextProvider = UnleashContextProvider.getDefaultProvider();

        static String getDefaultInstanceId() {
            String hostName = "";
            try {
                hostName = InetAddress.getLocalHost().getHostName() + "-";
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return hostName + "generated-" + Math.round(Math.random() * 1000000.0);
        }

        public Builder unleashAPI(URI unleashAPI) {
            this.unleashAPI = unleashAPI;
            return this;
        }

        public Builder unleashAPI(String unleashAPI) {
            this.unleashAPI = URI.create(unleashAPI);
            return this;
        }

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder fetchTogglesInterval(long fetchTogglesInterval) {
            this.fetchTogglesInterval = fetchTogglesInterval;
            return this;
        }

        public Builder sendMetricsInterval(long sendMetricsInterval) {
            this.sendMetricsInterval = sendMetricsInterval;
            return this;
        }

        public Builder disableMetrics() {
            this.disableMetrics = true;
            return this;
        }

        public Builder backupFile(String backupFile) {
            this.backupFile = backupFile;
            return this;
        }

        public Builder unleashContextProvider(UnleashContextProvider contextProvider) {
            this.contextProvider = contextProvider;
            return this;
        }

        private String getBackupFile() {
            if (this.backupFile != null) {
                return this.backupFile;
            }
            String fileName = "unleash-" + this.appName + "-repo.json";
            return System.getProperty("java.io.tmpdir") + File.separatorChar + fileName;
        }

        public UnleashConfig build() {
            return new UnleashConfig(this.unleashAPI, this.appName, this.instanceId, this.getBackupFile(), this.fetchTogglesInterval, this.sendMetricsInterval, this.disableMetrics, this.contextProvider);
        }
    }
}

