/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.util;

import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import no.finn.unleash.util.UnleashScheduledExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UnleashScheduledExecutorImpl
implements UnleashScheduledExecutor {
    private static final Logger LOG = LogManager.getLogger();
    private final ScheduledThreadPoolExecutor timer = new ScheduledThreadPoolExecutor(1, r -> {
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setName("unleash-api-executor");
        thread.setDaemon(true);
        return thread;
    });

    public UnleashScheduledExecutorImpl() {
        this.timer.setRemoveOnCancelPolicy(true);
    }

    @Override
    public ScheduledFuture setInterval(Runnable command, long initialDelaySec, long periodSec) {
        try {
            return this.timer.scheduleAtFixedRate(command, initialDelaySec, periodSec, TimeUnit.SECONDS);
        }
        catch (RejectedExecutionException ex) {
            LOG.error("Unleash background task crashed", (Throwable)ex);
            return null;
        }
    }
}

