/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import no.finn.unleash.FeatureToggle;
import no.finn.unleash.Unleash;
import no.finn.unleash.UnleashContext;
import no.finn.unleash.UnleashContextProvider;
import no.finn.unleash.Variant;
import no.finn.unleash.event.EventDispatcher;
import no.finn.unleash.event.ToggleEvaluated;
import no.finn.unleash.metric.UnleashMetricService;
import no.finn.unleash.metric.UnleashMetricServiceImpl;
import no.finn.unleash.repository.FeatureToggleRepository;
import no.finn.unleash.repository.HttpToggleFetcher;
import no.finn.unleash.repository.ToggleBackupHandlerFile;
import no.finn.unleash.repository.ToggleRepository;
import no.finn.unleash.strategy.ApplicationHostnameStrategy;
import no.finn.unleash.strategy.DefaultStrategy;
import no.finn.unleash.strategy.FlexibleRolloutStrategy;
import no.finn.unleash.strategy.GradualRolloutRandomStrategy;
import no.finn.unleash.strategy.GradualRolloutSessionIdStrategy;
import no.finn.unleash.strategy.GradualRolloutUserIdStrategy;
import no.finn.unleash.strategy.RemoteAddressStrategy;
import no.finn.unleash.strategy.Strategy;
import no.finn.unleash.strategy.UnknownStrategy;
import no.finn.unleash.strategy.UserWithIdStrategy;
import no.finn.unleash.util.UnleashConfig;
import no.finn.unleash.variant.VariantUtil;

public final class DefaultUnleash
implements Unleash {
    private static final List<Strategy> BUILTIN_STRATEGIES = Arrays.asList(new DefaultStrategy(), new ApplicationHostnameStrategy(), new GradualRolloutRandomStrategy(), new GradualRolloutSessionIdStrategy(), new GradualRolloutUserIdStrategy(), new RemoteAddressStrategy(), new UserWithIdStrategy(), new FlexibleRolloutStrategy());
    private static final UnknownStrategy UNKNOWN_STRATEGY = new UnknownStrategy();
    private final UnleashMetricService metricService;
    private final ToggleRepository toggleRepository;
    private final Map<String, Strategy> strategyMap;
    private final UnleashContextProvider contextProvider;
    private final EventDispatcher eventDispatcher;
    private final UnleashConfig config;

    private static FeatureToggleRepository defaultToggleRepository(UnleashConfig unleashConfig) {
        return new FeatureToggleRepository(unleashConfig, new HttpToggleFetcher(unleashConfig), new ToggleBackupHandlerFile(unleashConfig));
    }

    public DefaultUnleash(UnleashConfig unleashConfig, Strategy ... strategies) {
        this(unleashConfig, DefaultUnleash.defaultToggleRepository(unleashConfig), strategies);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, ToggleRepository toggleRepository, Strategy ... strategies) {
        this.config = unleashConfig;
        this.toggleRepository = toggleRepository;
        this.strategyMap = this.buildStrategyMap(strategies);
        this.contextProvider = unleashConfig.getContextProvider();
        this.eventDispatcher = new EventDispatcher(unleashConfig);
        this.metricService = new UnleashMetricServiceImpl(unleashConfig, unleashConfig.getScheduledExecutor());
        this.metricService.register(this.strategyMap.keySet());
    }

    @Override
    public boolean isEnabled(String toggleName) {
        return this.isEnabled(toggleName, false);
    }

    @Override
    public boolean isEnabled(String toggleName, boolean defaultSetting) {
        return this.isEnabled(toggleName, this.contextProvider.getContext(), defaultSetting);
    }

    @Override
    public boolean isEnabled(String toggleName, UnleashContext context, boolean defaultSetting) {
        return this.isEnabled(toggleName, context, (n, c) -> defaultSetting);
    }

    @Override
    public boolean isEnabled(String toggleName, BiFunction<String, UnleashContext, Boolean> fallbackAction) {
        return this.isEnabled(toggleName, this.contextProvider.getContext(), fallbackAction);
    }

    @Override
    public boolean isEnabled(String toggleName, UnleashContext context, BiFunction<String, UnleashContext, Boolean> fallbackAction) {
        boolean enabled = this.checkEnabled(toggleName, context, fallbackAction);
        this.count(toggleName, enabled);
        this.eventDispatcher.dispatch(new ToggleEvaluated(toggleName, enabled));
        return enabled;
    }

    private boolean checkEnabled(String toggleName, UnleashContext context, BiFunction<String, UnleashContext, Boolean> fallbackAction) {
        boolean enabled;
        FeatureToggle featureToggle = this.toggleRepository.getToggle(toggleName);
        UnleashContext enhancedContext = context.applyStaticFields(this.config);
        if (featureToggle == null) {
            enabled = fallbackAction.apply(toggleName, enhancedContext);
        } else if (!featureToggle.isEnabled()) {
            enabled = false;
        } else {
            if (featureToggle.getStrategies().size() == 0) {
                return true;
            }
            enabled = featureToggle.getStrategies().stream().anyMatch(as -> this.getStrategy(as.getName()).isEnabled(as.getParameters(), enhancedContext, as.getConstraints()));
        }
        return enabled;
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context) {
        return this.getVariant(toggleName, context, Variant.DISABLED_VARIANT);
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context, Variant defaultValue) {
        FeatureToggle featureToggle = this.toggleRepository.getToggle(toggleName);
        boolean enabled = this.checkEnabled(toggleName, context, (n, c) -> false);
        Variant variant = enabled ? VariantUtil.selectVariant(featureToggle, context, defaultValue) : defaultValue;
        this.metricService.countVariant(toggleName, variant.getName());
        return variant;
    }

    @Override
    public Variant getVariant(String toggleName) {
        return this.getVariant(toggleName, this.contextProvider.getContext());
    }

    @Override
    public Variant getVariant(String toggleName, Variant defaultValue) {
        return this.getVariant(toggleName, this.contextProvider.getContext(), defaultValue);
    }

    public Optional<FeatureToggle> getFeatureToggleDefinition(String toggleName) {
        return Optional.ofNullable(this.toggleRepository.getToggle(toggleName));
    }

    @Override
    public List<String> getFeatureToggleNames() {
        return this.toggleRepository.getFeatureNames();
    }

    public void count(String toggleName, boolean enabled) {
        this.metricService.count(toggleName, enabled);
    }

    private Map<String, Strategy> buildStrategyMap(Strategy[] strategies) {
        HashMap<String, Strategy> map = new HashMap<String, Strategy>();
        BUILTIN_STRATEGIES.forEach(strategy -> map.put(strategy.getName(), (Strategy)strategy));
        if (strategies != null) {
            for (Strategy strategy2 : strategies) {
                map.put(strategy2.getName(), strategy2);
            }
        }
        return map;
    }

    private Strategy getStrategy(String strategy) {
        return this.strategyMap.containsKey(strategy) ? this.strategyMap.get(strategy) : UNKNOWN_STRATEGY;
    }

    @Override
    public void shutdown() {
        this.config.getScheduledExecutor().shutdown();
    }
}

