/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.metric;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

class ToggleCount {
    private final AtomicLong yes = new AtomicLong(0L);
    private final AtomicLong no = new AtomicLong(0L);
    private final ConcurrentMap<String, AtomicLong> variants = new ConcurrentHashMap<String, AtomicLong>();

    public void register(boolean active) {
        if (active) {
            this.yes.incrementAndGet();
        } else {
            this.no.incrementAndGet();
        }
    }

    public void register(String variantName) {
        AtomicLong current = this.variants.computeIfAbsent(variantName, s -> new AtomicLong());
        current.incrementAndGet();
    }

    public long getYes() {
        return this.yes.get();
    }

    public long getNo() {
        return this.no.get();
    }

    public Map<String, ? extends Number> getVariants() {
        return this.variants;
    }
}

