/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.repository;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import no.finn.unleash.ActivationStrategy;
import no.finn.unleash.FeatureToggle;
import no.finn.unleash.repository.ToggleCollection;

public class JsonToggleCollectionDeserializer
implements JsonDeserializer<ToggleCollection> {
    private static final Type PARAMS_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type FEATURE_COLLECTION_TYPE = new TypeToken<Collection<FeatureToggle>>(){}.getType();

    public ToggleCollection deserialize(JsonElement rootElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        int version = this.getVersion(rootElement);
        switch (version) {
            case 0: {
                return JsonToggleCollectionDeserializer.deserializeVersion0(rootElement, context);
            }
        }
        return JsonToggleCollectionDeserializer.deserializeVersion1(rootElement, context);
    }

    static ToggleCollection deserializeVersion0(JsonElement rootElement, JsonDeserializationContext context) {
        if (!rootElement.getAsJsonObject().has("features")) {
            return null;
        }
        ArrayList<FeatureToggle> featureToggles = new ArrayList<FeatureToggle>();
        JsonArray features = rootElement.getAsJsonObject().getAsJsonArray("features");
        features.forEach(elm -> {
            JsonObject featureObj = elm.getAsJsonObject();
            String name = featureObj.get("name").getAsString();
            boolean enabled = featureObj.get("enabled").getAsBoolean();
            String strategyName = featureObj.get("strategy").getAsString();
            Map strategyParams = (Map)context.deserialize(featureObj.get("parameters"), PARAMS_TYPE);
            ActivationStrategy strategy = new ActivationStrategy(strategyName, strategyParams);
            featureToggles.add(new FeatureToggle(name, enabled, Collections.singletonList(strategy), Collections.emptyList()));
        });
        return new ToggleCollection(featureToggles);
    }

    static ToggleCollection deserializeVersion1(JsonElement rootElement, JsonDeserializationContext context) {
        if (!rootElement.getAsJsonObject().has("features")) {
            return null;
        }
        JsonArray featureArray = rootElement.getAsJsonObject().getAsJsonArray("features");
        Collection featureTgggles = (Collection)context.deserialize((JsonElement)featureArray, FEATURE_COLLECTION_TYPE);
        return new ToggleCollection(featureTgggles);
    }

    private int getVersion(JsonElement rootElement) {
        if (!rootElement.getAsJsonObject().has("version")) {
            return 0;
        }
        return rootElement.getAsJsonObject().get("version").getAsInt();
    }
}

