/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.strategy;

import java.util.Map;
import java.util.Optional;
import no.finn.unleash.UnleashContext;
import no.finn.unleash.strategy.Strategy;
import no.finn.unleash.strategy.StrategyUtils;

public final class GradualRolloutUserIdStrategy
implements Strategy {
    protected static final String PERCENTAGE = "percentage";
    protected static final String GROUP_ID = "groupId";
    private static final String NAME = "gradualRolloutUserId";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Map<String, String> parameters) {
        return false;
    }

    @Override
    public boolean isEnabled(Map<String, String> parameters, UnleashContext unleashContext) {
        Optional<String> userId = unleashContext.getUserId();
        if (!userId.isPresent()) {
            return false;
        }
        int percentage = StrategyUtils.getPercentage(parameters.get(PERCENTAGE));
        String groupId = Optional.ofNullable(parameters.get(GROUP_ID)).orElse("");
        int normalizedUserId = StrategyUtils.getNormalizedNumber(userId.get(), groupId);
        return percentage > 0 && normalizedUserId <= percentage;
    }
}

