/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.strategy;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import no.finn.unleash.UnleashContext;
import no.finn.unleash.strategy.Strategy;
import no.finn.unleash.strategy.StrategyUtils;

public class FlexibleRolloutStrategy
implements Strategy {
    protected static final String PERCENTAGE = "rollout";
    protected static final String GROUP_ID = "groupId";
    private Supplier<String> randomGenerator;

    public FlexibleRolloutStrategy() {
        this.randomGenerator = () -> Math.random() * 100.0 + "";
    }

    public FlexibleRolloutStrategy(Supplier<String> randomGenerator) {
        this.randomGenerator = randomGenerator;
    }

    @Override
    public String getName() {
        return "flexibleRollout";
    }

    @Override
    public boolean isEnabled(Map<String, String> parameters) {
        return false;
    }

    private Optional<String> resolveStickiness(String stickiness, UnleashContext context) {
        switch (stickiness) {
            case "userId": {
                return context.getUserId();
            }
            case "sessionId": {
                return context.getSessionId();
            }
            case "random": {
                return Optional.of(this.randomGenerator.get());
            }
        }
        String value = context.getUserId().orElse(context.getSessionId().orElse(this.randomGenerator.get()));
        return Optional.of(value);
    }

    @Override
    public boolean isEnabled(Map<String, String> parameters, UnleashContext unleashContext) {
        String stickiness = this.getStickiness(parameters);
        Optional<String> stickinessId = this.resolveStickiness(stickiness, unleashContext);
        int percentage = StrategyUtils.getPercentage(parameters.get(PERCENTAGE));
        String groupId = Optional.ofNullable(parameters.get(GROUP_ID)).orElse("");
        if (stickinessId.isPresent()) {
            int normalizedUserId = StrategyUtils.getNormalizedNumber(stickinessId.get(), groupId);
            return percentage > 0 && normalizedUserId <= percentage;
        }
        return false;
    }

    private String getStickiness(Map<String, String> parameters) {
        Optional<String> stickiness = Optional.ofNullable(parameters.get("stickiness"));
        return stickiness.orElse("default");
    }
}

