/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.AbstractLoader;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;

public abstract class AbstractFileLoader
extends AbstractLoader
implements FileSourcedConverter,
EnvironmentHandler {
    private static final long serialVersionUID = 5535537461920594758L;
    protected String m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
    protected transient Instances m_structure = null;
    protected File m_sourceFile = null;
    public static String FILE_EXTENSION_COMPRESSED = ".gz";
    protected boolean m_useRelativePath = false;
    protected transient Environment m_env;

    @Override
    public File retrieveFile() {
        return new File(this.m_File);
    }

    @Override
    public void setFile(File file) throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        this.setSource(file);
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
        try {
            this.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void reset() throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
    }

    @Override
    public void setSource(File file) throws IOException {
        File original = file;
        this.m_structure = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        String fName = file.getPath();
        try {
            if (this.m_env == null) {
                this.m_env = Environment.getSystemWide();
            }
            fName = this.m_env.substitute(fName);
        }
        catch (Exception e) {
            // empty catch block
        }
        file = new File(fName);
        if (file.exists() && file.isFile()) {
            if (file.getName().endsWith(this.getFileExtension() + FILE_EXTENSION_COMPRESSED)) {
                this.setSource(new GZIPInputStream(new FileInputStream(file)));
            } else {
                this.setSource(new FileInputStream(file));
            }
        } else {
            String fnameWithCorrectSeparators = fName.replace(File.separatorChar, '/');
            if (this.getClass().getClassLoader().getResource(fnameWithCorrectSeparators) != null) {
                this.setSource(this.getClass().getClassLoader().getResourceAsStream(fnameWithCorrectSeparators));
            }
        }
        if (this.m_useRelativePath) {
            try {
                this.m_sourceFile = Utils.convertToRelativePath(original);
                this.m_File = this.m_sourceFile.getPath();
            }
            catch (Exception ex) {
                this.m_sourceFile = original;
                this.m_File = this.m_sourceFile.getPath();
            }
        } else {
            this.m_sourceFile = original;
            this.m_File = this.m_sourceFile.getPath();
        }
    }

    public String useRelativePathTipText() {
        return "Use relative rather than absolute paths";
    }

    @Override
    public void setUseRelativePath(boolean rp) {
        this.m_useRelativePath = rp;
    }

    @Override
    public boolean getUseRelativePath() {
        return this.m_useRelativePath;
    }

    protected static String makeOptionStr(AbstractFileLoader loader) {
        StringBuffer result = new StringBuffer("\nUsage:\n");
        result.append("\t" + loader.getClass().getName().replaceAll(".*\\.", ""));
        if (loader instanceof OptionHandler) {
            result.append(" [options]");
        }
        result.append(" <");
        String[] ext = loader.getFileExtensions();
        for (int i = 0; i < ext.length; ++i) {
            if (i > 0) {
                result.append(" | ");
            }
            result.append("file" + ext[i]);
        }
        result.append(">\n");
        if (loader instanceof OptionHandler) {
            result.append("\nOptions:\n\n");
            Enumeration<Option> enm = ((OptionHandler)((Object)loader)).listOptions();
            while (enm.hasMoreElements()) {
                Option option = enm.nextElement();
                result.append(option.synopsis() + "\n");
                result.append(option.description() + "\n");
            }
        }
        return result.toString();
    }

    public static void runFileLoader(AbstractFileLoader loader, String[] options) {
        block14: {
            try {
                String[] tmpOptions = (String[])options.clone();
                if (Utils.getFlag('h', tmpOptions)) {
                    System.err.println("\nHelp requested\n" + AbstractFileLoader.makeOptionStr(loader));
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (options.length > 0) {
                if (loader instanceof OptionHandler) {
                    try {
                        ((OptionHandler)((Object)loader)).setOptions(options);
                        for (int i = 0; i < options.length; ++i) {
                            if (options[i].length() <= 0) continue;
                            options = new String[]{options[i]};
                            break;
                        }
                    }
                    catch (Exception ex) {
                        System.err.println(AbstractFileLoader.makeOptionStr(loader));
                        System.exit(1);
                    }
                }
                try {
                    loader.setFile(new File(options[0]));
                    if (loader instanceof IncrementalConverter) {
                        Instance temp;
                        Instances structure = loader.getStructure();
                        System.out.println(structure);
                        do {
                            if ((temp = loader.getNextInstance(structure)) == null) continue;
                            System.out.println(temp);
                        } while (temp != null);
                        break block14;
                    }
                    System.out.println(loader.getDataSet());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                System.err.println(AbstractFileLoader.makeOptionStr(loader));
            }
        }
    }
}

