/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.InstancesSummaryPanel;
import weka.gui.ListSelectorDialog;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SetInstancesPanel;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.explorer.Messages;
import weka.gui.hierarchyvisualizer.HierarchyVisualizer;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class ClustererPanel
extends JPanel
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    static final long serialVersionUID = -2474932792950820990L;
    protected Explorer m_Explorer = null;
    public static String MODEL_FILE_EXTENSION = ".model";
    protected GenericObjectEditor m_ClustererEditor = new GenericObjectEditor();
    protected PropertyPanel m_CLPanel = new PropertyPanel(this.m_ClustererEditor);
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JRadioButton m_PercentBut;
    protected JRadioButton m_TrainBut;
    protected JRadioButton m_TestSplitBut;
    protected JRadioButton m_ClassesToClustersBut;
    protected JComboBox m_ClassCombo;
    protected JLabel m_PercentLab;
    protected JTextField m_PercentText;
    protected JButton m_SetTestBut;
    protected JFrame m_SetTestFrame;
    protected JButton m_ignoreBut;
    protected DefaultListModel m_ignoreKeyModel;
    protected JList m_ignoreKeyList;
    ActionListener m_RadioListener;
    protected JButton m_StartBut;
    private final Dimension COMBO_SIZE;
    protected JButton m_StopBut;
    protected Instances m_Instances;
    protected Instances m_TestInstances;
    protected VisualizePanel m_CurrentVis;
    protected JCheckBox m_StorePredictionsBut;
    protected Thread m_RunThread;
    protected InstancesSummaryPanel m_Summary;
    protected FileFilter m_ModelFilter;
    protected JFileChooser m_FileChooser;

    public ClustererPanel() {
        Messages.getInstance();
        this.m_PercentBut = new JRadioButton(Messages.getString("ClustererPanel_PercentBut_JRadioButton_Text"));
        Messages.getInstance();
        this.m_TrainBut = new JRadioButton(Messages.getString("ClustererPanel_TrainBut_JRadioButton_Text"));
        Messages.getInstance();
        this.m_TestSplitBut = new JRadioButton(Messages.getString("ClustererPanel_TestSplitBut_JRadioButton_Text"));
        Messages.getInstance();
        this.m_ClassesToClustersBut = new JRadioButton(Messages.getString("ClustererPanel_ClassesToClustersBut_JRadioButton_Text"));
        this.m_ClassCombo = new JComboBox();
        this.m_PercentLab = new JLabel("%", 4);
        this.m_PercentText = new JTextField("66");
        Messages.getInstance();
        this.m_SetTestBut = new JButton(Messages.getString("ClustererPanel_SetTestBut_JButton_Text"));
        Messages.getInstance();
        this.m_ignoreBut = new JButton(Messages.getString("ClustererPanel_IgnoreBut_JButton_Text"));
        this.m_ignoreKeyModel = new DefaultListModel();
        this.m_ignoreKeyList = new JList(this.m_ignoreKeyModel);
        this.m_RadioListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClustererPanel.this.updateRadioLinks();
            }
        };
        Messages.getInstance();
        this.m_StartBut = new JButton(Messages.getString("ClustererPanel_StartBut_JButton_Text"));
        this.COMBO_SIZE = new Dimension(250, this.m_StartBut.getPreferredSize().height);
        Messages.getInstance();
        this.m_StopBut = new JButton(Messages.getString("ClustererPanel_StopBut_JButton_Text"));
        this.m_CurrentVis = null;
        Messages.getInstance();
        this.m_StorePredictionsBut = new JCheckBox(Messages.getString("ClustererPanel_StopBut_JCheckBox_Text"));
        Messages.getInstance();
        this.m_ModelFilter = new ExtensionFileFilter(MODEL_FILE_EXTENSION, Messages.getString("ClustererPanel_ModelFilter_ExtensionFileFilter_Text"));
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16) {
                    ClustererPanel.this.m_OutText.selectAll();
                }
            }
        });
        Messages.getInstance();
        this.m_History.setBorder(BorderFactory.createTitledBorder(Messages.getString("ClustererPanel_History_BorderFactoryCreateTitledBorder_Text")));
        this.m_ClustererEditor.setClassType(Clusterer.class);
        this.m_ClustererEditor.setValue(ExplorerDefaults.getClusterer());
        this.m_ClustererEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ClustererPanel.this.m_StartBut.setEnabled(true);
                Capabilities currentFilter = ClustererPanel.this.m_ClustererEditor.getCapabilitiesFilter();
                Clusterer clusterer = (Clusterer)ClustererPanel.this.m_ClustererEditor.getValue();
                Capabilities currentSchemeCapabilities = null;
                if (clusterer != null && currentFilter != null && clusterer instanceof CapabilitiesHandler && !(currentSchemeCapabilities = ((CapabilitiesHandler)((Object)clusterer)).getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
                    ClustererPanel.this.m_StartBut.setEnabled(false);
                }
                ClustererPanel.this.repaint();
            }
        });
        Messages.getInstance();
        this.m_TrainBut.setToolTipText(Messages.getString("ClustererPanel_TrainBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_PercentBut.setToolTipText(Messages.getString("ClustererPanel_PercentBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_TestSplitBut.setToolTipText(Messages.getString("ClustererPanel_TestSplitBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_ClassesToClustersBut.setToolTipText(Messages.getString("ClustererPanel_ClassesToClustersBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_ClassCombo.setToolTipText(Messages.getString("ClustererPanel_ClassCombo_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_StartBut.setToolTipText(Messages.getString("ClustererPanel_StartBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_StopBut.setToolTipText(Messages.getString("ClustererPanel_StartBut_StopBut_Text"));
        Messages.getInstance();
        this.m_StorePredictionsBut.setToolTipText(Messages.getString("ClustererPanel_StorePredictionsBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_ignoreBut.setToolTipText(Messages.getString("ClustererPanel_IgnoreBut_SetToolTipText_Text"));
        this.m_FileChooser.setFileFilter(this.m_ModelFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_ClassCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setEnabled(false);
        this.m_PercentBut.setSelected(ExplorerDefaults.getClustererTestMode() == 2);
        this.m_TrainBut.setSelected(ExplorerDefaults.getClustererTestMode() == 3);
        this.m_TestSplitBut.setSelected(ExplorerDefaults.getClustererTestMode() == 4);
        this.m_ClassesToClustersBut.setSelected(ExplorerDefaults.getClustererTestMode() == 5);
        this.m_StorePredictionsBut.setSelected(ExplorerDefaults.getClustererStoreClustersForVis());
        this.updateRadioLinks();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_TrainBut);
        bg.add(this.m_PercentBut);
        bg.add(this.m_TestSplitBut);
        bg.add(this.m_ClassesToClustersBut);
        this.m_TrainBut.addActionListener(this.m_RadioListener);
        this.m_PercentBut.addActionListener(this.m_RadioListener);
        this.m_TestSplitBut.addActionListener(this.m_RadioListener);
        this.m_ClassesToClustersBut.addActionListener(this.m_RadioListener);
        this.m_SetTestBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClustererPanel.this.setTestSet();
            }
        });
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_ignoreBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean proceed = true;
                if (Explorer.m_Memory.memoryIsLow()) {
                    proceed = Explorer.m_Memory.showMemoryIsLow();
                }
                if (proceed) {
                    ClustererPanel.this.startClusterer();
                }
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClustererPanel.this.stopClusterer();
            }
        });
        this.m_ignoreBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClustererPanel.this.setIgnoreColumns();
            }
        });
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    int index = ClustererPanel.this.m_History.getList().locationToIndex(e.getPoint());
                    if (index != -1) {
                        String name = ClustererPanel.this.m_History.getNameAtIndex(index);
                        ClustererPanel.this.visualizeClusterer(name, e.getX(), e.getY());
                    } else {
                        ClustererPanel.this.visualizeClusterer(null, e.getX(), e.getY());
                    }
                }
            }
        });
        this.m_ClassCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClustererPanel.this.updateCapabilitiesFilter(ClustererPanel.this.m_ClustererEditor.getCapabilitiesFilter());
            }
        });
        JPanel p1 = new JPanel();
        Messages.getInstance();
        p1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("ClustererPanel_P1_BorderFactoryCreateTitledBorder_Text")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_CLPanel, "North");
        JPanel p2 = new JPanel();
        GridBagLayout gbL = new GridBagLayout();
        p2.setLayout(gbL);
        Messages.getInstance();
        p2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("ClustererPanel_P2_BorderFactoryCreateTitledBorder_Text")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_TrainBut, gbC);
        p2.add(this.m_TrainBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_TestSplitBut, gbC);
        p2.add(this.m_TestSplitBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 1;
        gbC.gridwidth = 2;
        gbC.insets = new Insets(2, 10, 2, 0);
        gbL.setConstraints(this.m_SetTestBut, gbC);
        p2.add(this.m_SetTestBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_PercentBut, gbC);
        p2.add(this.m_PercentBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 2;
        gbC.gridx = 1;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(this.m_PercentLab, gbC);
        p2.add(this.m_PercentLab);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 2;
        gbC.gridx = 2;
        gbC.weightx = 100.0;
        gbC.ipadx = 20;
        gbL.setConstraints(this.m_PercentText, gbC);
        p2.add(this.m_PercentText);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 3;
        gbC.gridx = 0;
        gbC.gridwidth = 2;
        gbL.setConstraints(this.m_ClassesToClustersBut, gbC);
        p2.add(this.m_ClassesToClustersBut);
        this.m_ClassCombo.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 4;
        gbC.gridx = 0;
        gbC.gridwidth = 2;
        gbL.setConstraints(this.m_ClassCombo, gbC);
        p2.add(this.m_ClassCombo);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 5;
        gbC.gridx = 0;
        gbC.gridwidth = 2;
        gbL.setConstraints(this.m_StorePredictionsBut, gbC);
        p2.add(this.m_StorePredictionsBut);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(2, 1));
        JPanel ssButs = new JPanel();
        ssButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ssButs.setLayout(new GridLayout(1, 2, 5, 5));
        ssButs.add(this.m_StartBut);
        ssButs.add(this.m_StopBut);
        JPanel ib = new JPanel();
        ib.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ib.setLayout(new GridLayout(1, 1, 5, 5));
        ib.add(this.m_ignoreBut);
        buttons.add(ib);
        buttons.add(ssButs);
        JPanel p3 = new JPanel();
        Messages.getInstance();
        p3.setBorder(BorderFactory.createTitledBorder(Messages.getString("ClustererPanel_P3_BorderFactoryCreateTitledBorder_Text")));
        p3.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(this.m_OutText);
        p3.add((Component)js, "Center");
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        JPanel mondo = new JPanel();
        gbL = new GridBagLayout();
        mondo.setLayout(gbL);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbL.setConstraints(p2, gbC);
        mondo.add(p2);
        gbC = new GridBagConstraints();
        gbC.anchor = 11;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbL.setConstraints(buttons, gbC);
        mondo.add(buttons);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbL.setConstraints(this.m_History, gbC);
        mondo.add(this.m_History);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.gridheight = 3;
        gbC.weightx = 100.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(p3, gbC);
        mondo.add(p3);
        this.setLayout(new BorderLayout());
        this.add((Component)p1, "North");
        this.add((Component)mondo, "Center");
    }

    protected void updateRadioLinks() {
        this.m_SetTestBut.setEnabled(this.m_TestSplitBut.isSelected());
        if (this.m_SetTestFrame != null && !this.m_TestSplitBut.isSelected()) {
            this.m_SetTestFrame.setVisible(false);
        }
        this.m_PercentText.setEnabled(this.m_PercentBut.isSelected());
        this.m_PercentLab.setEnabled(this.m_PercentBut.isSelected());
        this.m_ClassCombo.setEnabled(this.m_ClassesToClustersBut.isSelected());
        this.updateCapabilitiesFilter(this.m_ClustererEditor.getCapabilitiesFilter());
    }

    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        this.m_ignoreKeyModel.removeAllElements();
        String[] attribNames = new String[this.m_Instances.numAttributes()];
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            String name = this.m_Instances.attribute(i).name();
            this.m_ignoreKeyModel.addElement(name);
            String type = "";
            switch (this.m_Instances.attribute(i).type()) {
                case 1: {
                    Messages.getInstance();
                    type = Messages.getString("ClustererPanel_SetInstances_Type_AttributeNOMINAL_Text");
                    break;
                }
                case 0: {
                    Messages.getInstance();
                    type = Messages.getString("ClustererPanel_SetInstances_Type_AttributeNUMERIC_Text");
                    break;
                }
                case 2: {
                    Messages.getInstance();
                    type = Messages.getString("ClustererPanel_SetInstances_Type_AttributeSTRING_Text");
                    break;
                }
                case 3: {
                    Messages.getInstance();
                    type = Messages.getString("ClustererPanel_SetInstances_Type_AttributeDATE_Text");
                    break;
                }
                case 4: {
                    Messages.getInstance();
                    type = Messages.getString("ClustererPanel_SetInstances_Type_AttributeRELATIONAL_Text");
                    break;
                }
                default: {
                    Messages.getInstance();
                    type = Messages.getString("ClustererPanel_SetInstances_Type_AttributeDEFAULT_Text");
                }
            }
            String attnm = this.m_Instances.attribute(i).name();
            attribNames[i] = type + attnm;
        }
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
        this.m_ignoreBut.setEnabled(true);
        this.m_ClassCombo.setModel(new DefaultComboBoxModel<String>(attribNames));
        if (inst.classIndex() == -1) {
            this.m_ClassCombo.setSelectedIndex(attribNames.length - 1);
        } else {
            this.m_ClassCombo.setSelectedIndex(inst.classIndex());
        }
        this.updateRadioLinks();
    }

    protected void setTestSet() {
        if (this.m_SetTestFrame == null) {
            final SetInstancesPanel sp = new SetInstancesPanel();
            sp.setReadIncrementally(false);
            this.m_Summary = sp.getSummary();
            if (this.m_TestInstances != null) {
                sp.setInstances(this.m_TestInstances);
            }
            sp.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    ClustererPanel.this.m_TestInstances = sp.getInstances();
                    ClustererPanel.this.m_TestInstances.setClassIndex(-1);
                }
            });
            Messages.getInstance();
            this.m_SetTestFrame = new JFrame(Messages.getString("ClustererPanel_SetUpVisualizableInstances_JFrame_Text"));
            sp.setParentFrame(this.m_SetTestFrame);
            this.m_SetTestFrame.getContentPane().setLayout(new BorderLayout());
            this.m_SetTestFrame.getContentPane().add((Component)sp, "Center");
            this.m_SetTestFrame.pack();
        }
        this.m_SetTestFrame.setVisible(true);
    }

    public static PlotData2D setUpVisualizableInstances(Instances testInstances, ClusterEvaluation eval) throws Exception {
        int i;
        int i2;
        int numClusters = eval.getNumClusters();
        double[] clusterAssignments = eval.getClusterAssignments();
        FastVector hv = new FastVector();
        FastVector clustVals = new FastVector();
        for (i2 = 0; i2 < numClusters; ++i2) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            clustVals.addElement(stringBuilder.append(Messages.getString("ClustererPanel_SetUpVisualizableInstances_ClustVals_Text")).append(i2).toString());
        }
        Messages.getInstance();
        Attribute predictedCluster = new Attribute(Messages.getString("ClustererPanel_SetUpVisualizableInstances_PredictedCluster_Text"), clustVals);
        for (i2 = 0; i2 < testInstances.numAttributes(); ++i2) {
            hv.addElement(testInstances.attribute(i2).copy());
        }
        hv.addElement(predictedCluster);
        Instances newInsts = new Instances(testInstances.relationName() + "_clustered", hv, testInstances.numInstances());
        int[] pointShapes = null;
        int[] classAssignments = null;
        if (testInstances.classIndex() >= 0) {
            classAssignments = eval.getClassesToClusters();
            pointShapes = new int[testInstances.numInstances()];
            for (i = 0; i < testInstances.numInstances(); ++i) {
                pointShapes[i] = -1;
            }
        }
        for (i = 0; i < testInstances.numInstances(); ++i) {
            double[] values = new double[newInsts.numAttributes()];
            for (int j = 0; j < testInstances.numAttributes(); ++j) {
                values[j] = testInstances.instance(i).value(j);
            }
            values[j] = clusterAssignments[i] < 0.0 ? Instance.missingValue() : clusterAssignments[i];
            newInsts.add(new Instance(1.0, values));
            if (pointShapes == null) continue;
            if (clusterAssignments[i] >= 0.0) {
                if ((int)testInstances.instance(i).classValue() == classAssignments[(int)clusterAssignments[i]]) continue;
                pointShapes[i] = 1000;
                continue;
            }
            pointShapes[i] = 2000;
        }
        PlotData2D plotData = new PlotData2D(newInsts);
        if (pointShapes != null) {
            plotData.setShapeType(pointShapes);
        }
        plotData.addInstanceNumberAttribute();
        return plotData;
    }

    protected void startClusterer() {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_ignoreBut.setEnabled(false);
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block74: {
                        String cname;
                        String name;
                        Clusterer fullClusterer;
                        int[] ignoredAtts;
                        String grph;
                        boolean saveVis;
                        PlotData2D predData;
                        Instances inst;
                        block71: {
                            long trainTimeStart = 0L;
                            long trainTimeElapsed = 0L;
                            Logger logger = ClustererPanel.this.m_Log;
                            Messages.getInstance();
                            logger.statusMessage(Messages.getString("ClustererPanel_StartClusterer_Run_Log_StatusMessage_Text_First"));
                            inst = new Instances(ClustererPanel.this.m_Instances);
                            inst.setClassIndex(-1);
                            Instances userTest = null;
                            predData = null;
                            if (ClustererPanel.this.m_TestInstances != null) {
                                userTest = new Instances(ClustererPanel.this.m_TestInstances);
                            }
                            saveVis = ClustererPanel.this.m_StorePredictionsBut.isSelected();
                            grph = null;
                            ignoredAtts = null;
                            int testMode = 0;
                            int percent = 66;
                            Clusterer clusterer = (Clusterer)ClustererPanel.this.m_ClustererEditor.getValue();
                            fullClusterer = null;
                            StringBuffer outBuff = new StringBuffer();
                            name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                            cname = clusterer.getClass().getName();
                            name = cname.startsWith("weka.clusterers.") ? name + cname.substring("weka.clusterers.".length()) : name + cname;
                            String cmd = ClustererPanel.this.m_ClustererEditor.getValue().getClass().getName();
                            if (ClustererPanel.this.m_ClustererEditor.getValue() instanceof OptionHandler) {
                                cmd = cmd + " " + Utils.joinOptions(((OptionHandler)ClustererPanel.this.m_ClustererEditor.getValue()).getOptions());
                            }
                            Logger logger2 = ClustererPanel.this.m_Log;
                            StringBuilder stringBuilder = new StringBuilder();
                            Messages.getInstance();
                            logger2.logMessage(stringBuilder.append(Messages.getString("ClustererPanel_StartClusterer_Run_Log_LogMessage_Text_First")).append(cname).toString());
                            Logger logger3 = ClustererPanel.this.m_Log;
                            StringBuilder stringBuilder2 = new StringBuilder();
                            Messages.getInstance();
                            logger3.logMessage(stringBuilder2.append(Messages.getString("ClustererPanel_StartClusterer_Run_Log_LogMessage_Text_Second")).append(cmd).toString());
                            if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskStarted();
                            }
                            if (ClustererPanel.this.m_PercentBut.isSelected()) {
                                testMode = 2;
                                percent = Integer.parseInt(ClustererPanel.this.m_PercentText.getText());
                                if (percent <= 0 || percent >= 100) {
                                    Messages.getInstance();
                                    throw new Exception(Messages.getString("ClustererPanel_StartClusterer_Run_Exception_Text_First"));
                                }
                            } else if (ClustererPanel.this.m_TrainBut.isSelected()) {
                                testMode = 3;
                            } else if (ClustererPanel.this.m_TestSplitBut.isSelected()) {
                                testMode = 4;
                                if (userTest == null) {
                                    Messages.getInstance();
                                    throw new Exception(Messages.getString("ClustererPanel_StartClusterer_Run_Exception_Text_Second"));
                                }
                                if (!inst.equalHeaders(userTest)) {
                                    Messages.getInstance();
                                    throw new Exception(Messages.getString("ClustererPanel_StartClusterer_Run_Exception_Text_Third"));
                                }
                            } else if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                testMode = 5;
                            } else {
                                Messages.getInstance();
                                throw new Exception(Messages.getString("ClustererPanel_StartClusterer_Run_Exception_Text_Fourth"));
                            }
                            Instances trainInst = new Instances(inst);
                            if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                trainInst.setClassIndex(ClustererPanel.this.m_ClassCombo.getSelectedIndex());
                                inst.setClassIndex(ClustererPanel.this.m_ClassCombo.getSelectedIndex());
                                if (inst.classAttribute().isNumeric()) {
                                    Messages.getInstance();
                                    throw new Exception(Messages.getString("ClustererPanel_StartClusterer_Run_Exception_Text_Fifth"));
                                }
                            }
                            if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                trainInst = ClustererPanel.this.removeIgnoreCols(trainInst);
                            }
                            Messages.getInstance();
                            outBuff.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_First"));
                            StringBuilder stringBuilder3 = new StringBuilder();
                            Messages.getInstance();
                            outBuff.append(stringBuilder3.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Second")).append(cname).toString());
                            if (clusterer instanceof OptionHandler) {
                                String[] o = ((OptionHandler)((Object)clusterer)).getOptions();
                                outBuff.append(" " + Utils.joinOptions(o));
                            }
                            Messages.getInstance();
                            outBuff.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Third"));
                            StringBuilder stringBuilder4 = new StringBuilder();
                            Messages.getInstance();
                            outBuff.append(stringBuilder4.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Fourth")).append(inst.relationName()).append('\n').toString());
                            StringBuilder stringBuilder5 = new StringBuilder();
                            Messages.getInstance();
                            outBuff.append(stringBuilder5.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Sixth")).append(inst.numInstances()).append('\n').toString());
                            StringBuilder stringBuilder6 = new StringBuilder();
                            Messages.getInstance();
                            outBuff.append(stringBuilder6.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Eighth")).append(inst.numAttributes()).append('\n').toString());
                            if (inst.numAttributes() < 100) {
                                int i;
                                boolean[] selected = new boolean[inst.numAttributes()];
                                for (i = 0; i < inst.numAttributes(); ++i) {
                                    selected[i] = true;
                                }
                                if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                    int[] indices = ClustererPanel.this.m_ignoreKeyList.getSelectedIndices();
                                    for (int i2 = 0; i2 < indices.length; ++i2) {
                                        selected[indices[i2]] = false;
                                    }
                                }
                                if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                    selected[ClustererPanel.this.m_ClassCombo.getSelectedIndex()] = false;
                                }
                                for (i = 0; i < inst.numAttributes(); ++i) {
                                    if (!selected[i]) continue;
                                    outBuff.append("              " + inst.attribute(i).name() + '\n');
                                }
                                if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty() || ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                    Messages.getInstance();
                                    outBuff.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Eleventh"));
                                    for (i = 0; i < inst.numAttributes(); ++i) {
                                        if (selected[i]) continue;
                                        outBuff.append("              " + inst.attribute(i).name() + '\n');
                                    }
                                }
                            } else {
                                Messages.getInstance();
                                outBuff.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Thirteenth"));
                            }
                            if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                ignoredAtts = ClustererPanel.this.m_ignoreKeyList.getSelectedIndices();
                            }
                            if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                if (ignoredAtts == null) {
                                    ignoredAtts = new int[]{ClustererPanel.this.m_ClassCombo.getSelectedIndex()};
                                } else {
                                    int[] newIgnoredAtts = new int[ignoredAtts.length + 1];
                                    System.arraycopy(ignoredAtts, 0, newIgnoredAtts, 0, ignoredAtts.length);
                                    newIgnoredAtts[ignoredAtts.length] = ClustererPanel.this.m_ClassCombo.getSelectedIndex();
                                    ignoredAtts = newIgnoredAtts;
                                }
                            }
                            Messages.getInstance();
                            outBuff.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Fourteenth"));
                            switch (testMode) {
                                case 3: {
                                    Messages.getInstance();
                                    outBuff.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Fifteenth"));
                                    break;
                                }
                                case 2: {
                                    StringBuilder stringBuilder7 = new StringBuilder();
                                    Messages.getInstance();
                                    StringBuilder stringBuilder8 = stringBuilder7.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Sixteenth")).append(percent);
                                    Messages.getInstance();
                                    outBuff.append(stringBuilder8.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Seventeenth")).toString());
                                    break;
                                }
                                case 4: {
                                    StringBuilder stringBuilder9 = new StringBuilder();
                                    Messages.getInstance();
                                    StringBuilder stringBuilder10 = stringBuilder9.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Eighteenth")).append(userTest.numInstances());
                                    Messages.getInstance();
                                    outBuff.append(stringBuilder10.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Nineteenth")).toString());
                                    break;
                                }
                                case 5: {
                                    Messages.getInstance();
                                    outBuff.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_Twentyth"));
                                }
                            }
                            outBuff.append("\n");
                            ClustererPanel.this.m_History.addResult(name, outBuff);
                            ClustererPanel.this.m_History.setSingle(name);
                            Logger logger4 = ClustererPanel.this.m_Log;
                            Messages.getInstance();
                            logger4.statusMessage(Messages.getString("ClustererPanel_StartClusterer_Run_Log_StatusMessage_Second"));
                            trainTimeStart = System.currentTimeMillis();
                            clusterer.buildClusterer(ClustererPanel.this.removeClass(trainInst));
                            trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
                            Messages.getInstance();
                            outBuff.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_TwentySecond"));
                            outBuff.append(clusterer.toString() + '\n');
                            StringBuilder stringBuilder11 = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder12 = stringBuilder11.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_TimeTakenFull")).append(Utils.doubleToString((double)trainTimeElapsed / 1000.0, 2)).append(" ");
                            Messages.getInstance();
                            outBuff.append(stringBuilder12.append(Messages.getString("ClassifierPanel_StartClassifier_OutBuffer_Text_TwentyNineth")).toString());
                            ClustererPanel.this.m_History.updateResult(name);
                            if (clusterer instanceof Drawable) {
                                try {
                                    grph = ((Drawable)((Object)clusterer)).graph();
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            SerializedObject so = new SerializedObject(clusterer);
                            fullClusterer = (Clusterer)so.getObject();
                            ClusterEvaluation eval = new ClusterEvaluation();
                            eval.setClusterer(clusterer);
                            switch (testMode) {
                                case 3: 
                                case 5: {
                                    Logger logger5 = ClustererPanel.this.m_Log;
                                    Messages.getInstance();
                                    logger5.statusMessage(Messages.getString("ClustererPanel_StartClusterer_Run_Log_StatusMessage_Third"));
                                    eval.evaluateClusterer(trainInst, "", false);
                                    predData = ClustererPanel.setUpVisualizableInstances(inst, eval);
                                    Messages.getInstance();
                                    outBuff.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_TwentySecond"));
                                    break;
                                }
                                case 2: {
                                    Logger logger6 = ClustererPanel.this.m_Log;
                                    Messages.getInstance();
                                    logger6.statusMessage(Messages.getString("ClustererPanel_StartClusterer_Run_Log_StatusMessage_Fourth"));
                                    inst.randomize(new Random(1L));
                                    trainInst.randomize(new Random(1L));
                                    int trainSize = trainInst.numInstances() * percent / 100;
                                    int testSize = trainInst.numInstances() - trainSize;
                                    Instances train = new Instances(trainInst, 0, trainSize);
                                    Instances test = new Instances(trainInst, trainSize, testSize);
                                    Instances testVis = new Instances(inst, trainSize, testSize);
                                    Logger logger7 = ClustererPanel.this.m_Log;
                                    Messages.getInstance();
                                    logger7.statusMessage(Messages.getString("ClustererPanel_StartClusterer_Run_Log_StatusMessage_Fifth"));
                                    trainTimeStart = System.currentTimeMillis();
                                    clusterer.buildClusterer(train);
                                    trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
                                    Logger logger8 = ClustererPanel.this.m_Log;
                                    Messages.getInstance();
                                    logger8.statusMessage(Messages.getString("ClustererPanel_StartClusterer_Run_Log_StatusMessage_Sixth"));
                                    eval.evaluateClusterer(test, "", false);
                                    predData = ClustererPanel.setUpVisualizableInstances(testVis, eval);
                                    Messages.getInstance();
                                    outBuff.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_TwentyThird"));
                                    outBuff.append(clusterer.toString() + '\n');
                                    StringBuilder stringBuilder13 = new StringBuilder();
                                    Messages.getInstance();
                                    StringBuilder stringBuilder14 = stringBuilder13.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_TimeTakenPercentage")).append(Utils.doubleToString((double)trainTimeElapsed / 1000.0, 2)).append(" ");
                                    Messages.getInstance();
                                    outBuff.append(stringBuilder14.append(Messages.getString("ClassifierPanel_StartClassifier_OutBuffer_Text_TwentyNineth")).toString());
                                    break;
                                }
                                case 4: {
                                    Logger logger9 = ClustererPanel.this.m_Log;
                                    Messages.getInstance();
                                    logger9.statusMessage(Messages.getString("ClustererPanel_StartClusterer_Run_Log_StatusMessage_Seventh"));
                                    Instances userTestT = new Instances(userTest);
                                    if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                        userTestT = ClustererPanel.this.removeIgnoreCols(userTestT);
                                    }
                                    eval.evaluateClusterer(userTestT, "", false);
                                    predData = ClustererPanel.setUpVisualizableInstances(userTest, eval);
                                    Messages.getInstance();
                                    outBuff.append(Messages.getString("ClustererPanel_StartClusterer_Run_OutBuffer_Text_TwentyFourth"));
                                    break;
                                }
                                default: {
                                    Messages.getInstance();
                                    throw new Exception(Messages.getString("ClustererPanel_StartClusterer_Run_Exception_Text_Sixth"));
                                }
                            }
                            outBuff.append(eval.clusterResultsToString());
                            outBuff.append("\n");
                            ClustererPanel.this.m_History.updateResult(name);
                            Logger logger10 = ClustererPanel.this.m_Log;
                            StringBuilder stringBuilder15 = new StringBuilder();
                            Messages.getInstance();
                            logger10.logMessage(stringBuilder15.append(Messages.getString("ClustererPanel_StartClusterer_Run_Log_LogMessage_Text_Third")).append(cname).toString());
                            Logger logger11 = ClustererPanel.this.m_Log;
                            Messages.getInstance();
                            logger11.statusMessage(Messages.getString("ClustererPanel_StartClusterer_Run_Log_StatusMessage_Eighth"));
                            Object var29_30 = null;
                            if (predData == null) break block71;
                            ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                            ClustererPanel.this.m_CurrentVis.setName(name + " (" + inst.relationName() + ")");
                            ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                            predData.setPlotName(name + " (" + inst.relationName() + ")");
                            try {
                                ClustererPanel.this.m_CurrentVis.addPlot(predData);
                            }
                            catch (Exception ex2) {
                                System.err.println(ex2);
                            }
                            FastVector vv = new FastVector();
                            vv.addElement(fullClusterer);
                            Instances trainHeader = new Instances(ClustererPanel.this.m_Instances, 0);
                            vv.addElement(trainHeader);
                            if (ignoredAtts != null) {
                                vv.addElement(ignoredAtts);
                            }
                            if (saveVis) {
                                vv.addElement(ClustererPanel.this.m_CurrentVis);
                                if (grph != null) {
                                    vv.addElement(grph);
                                }
                            }
                            ClustererPanel.this.m_History.addObject(name, vv);
                        }
                        if (this.isInterrupted()) {
                            Logger logger = ClustererPanel.this.m_Log;
                            StringBuilder stringBuilder = new StringBuilder();
                            Messages.getInstance();
                            logger.logMessage(stringBuilder.append(Messages.getString("ClustererPanel_StartClusterer_Run_Log_LogMessage_Text_Fourth")).append(cname).toString());
                            Logger logger12 = ClustererPanel.this.m_Log;
                            Messages.getInstance();
                            logger12.statusMessage(Messages.getString("ClustererPanel_StartClusterer_Run_Log_StatusMessage_Tenth"));
                        }
                        ClustererPanel.this.m_RunThread = null;
                        ClustererPanel.this.m_StartBut.setEnabled(true);
                        ClustererPanel.this.m_StopBut.setEnabled(false);
                        ClustererPanel.this.m_ignoreBut.setEnabled(true);
                        if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                        }
                        break block74;
                        {
                            catch (Exception ex) {
                                ex.printStackTrace();
                                ClustererPanel.this.m_Log.logMessage(ex.getMessage());
                                StringBuilder stringBuilder = new StringBuilder();
                                Messages.getInstance();
                                String string = stringBuilder.append(Messages.getString("ClustererPanel_StartClusterer_Run_JOptionPaneShowMessageDialog_Text_First")).append(ex.getMessage()).toString();
                                Messages.getInstance();
                                JOptionPane.showMessageDialog(ClustererPanel.this, string, Messages.getString("ClustererPanel_StartClusterer_Run_JOptionPaneShowMessageDialog_Text_Second"), 0);
                                Logger logger = ClustererPanel.this.m_Log;
                                Messages.getInstance();
                                logger.statusMessage(Messages.getString("ClustererPanel_StartClusterer_Run_Log_StatusMessage_Nineth"));
                                Object var29_31 = null;
                                if (predData != null) {
                                    ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                                    ClustererPanel.this.m_CurrentVis.setName(name + " (" + inst.relationName() + ")");
                                    ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                                    predData.setPlotName(name + " (" + inst.relationName() + ")");
                                    try {
                                        ClustererPanel.this.m_CurrentVis.addPlot(predData);
                                    }
                                    catch (Exception ex2) {
                                        System.err.println(ex2);
                                    }
                                    FastVector vv = new FastVector();
                                    vv.addElement(fullClusterer);
                                    Instances trainHeader = new Instances(ClustererPanel.this.m_Instances, 0);
                                    vv.addElement(trainHeader);
                                    if (ignoredAtts != null) {
                                        vv.addElement(ignoredAtts);
                                    }
                                    if (saveVis) {
                                        vv.addElement(ClustererPanel.this.m_CurrentVis);
                                        if (grph != null) {
                                            vv.addElement(grph);
                                        }
                                    }
                                    ClustererPanel.this.m_History.addObject(name, vv);
                                }
                                if (this.isInterrupted()) {
                                    Logger logger13 = ClustererPanel.this.m_Log;
                                    StringBuilder stringBuilder16 = new StringBuilder();
                                    Messages.getInstance();
                                    logger13.logMessage(stringBuilder16.append(Messages.getString("ClustererPanel_StartClusterer_Run_Log_LogMessage_Text_Fourth")).append(cname).toString());
                                    Logger logger14 = ClustererPanel.this.m_Log;
                                    Messages.getInstance();
                                    logger14.statusMessage(Messages.getString("ClustererPanel_StartClusterer_Run_Log_StatusMessage_Tenth"));
                                }
                                ClustererPanel.this.m_RunThread = null;
                                ClustererPanel.this.m_StartBut.setEnabled(true);
                                ClustererPanel.this.m_StopBut.setEnabled(false);
                                ClustererPanel.this.m_ignoreBut.setEnabled(true);
                                if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                    ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var29_32 = null;
                            if (predData != null) {
                                ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                                ClustererPanel.this.m_CurrentVis.setName(name + " (" + inst.relationName() + ")");
                                ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                                predData.setPlotName(name + " (" + inst.relationName() + ")");
                                try {
                                    ClustererPanel.this.m_CurrentVis.addPlot(predData);
                                }
                                catch (Exception ex2) {
                                    System.err.println(ex2);
                                }
                                FastVector vv = new FastVector();
                                vv.addElement(fullClusterer);
                                Instances trainHeader = new Instances(ClustererPanel.this.m_Instances, 0);
                                vv.addElement(trainHeader);
                                if (ignoredAtts != null) {
                                    vv.addElement(ignoredAtts);
                                }
                                if (saveVis) {
                                    vv.addElement(ClustererPanel.this.m_CurrentVis);
                                    if (grph != null) {
                                        vv.addElement(grph);
                                    }
                                }
                                ClustererPanel.this.m_History.addObject(name, vv);
                            }
                            if (this.isInterrupted()) {
                                Logger logger = ClustererPanel.this.m_Log;
                                StringBuilder stringBuilder = new StringBuilder();
                                Messages.getInstance();
                                logger.logMessage(stringBuilder.append(Messages.getString("ClustererPanel_StartClusterer_Run_Log_LogMessage_Text_Fourth")).append(cname).toString());
                                Logger logger15 = ClustererPanel.this.m_Log;
                                Messages.getInstance();
                                logger15.statusMessage(Messages.getString("ClustererPanel_StartClusterer_Run_Log_StatusMessage_Tenth"));
                            }
                            ClustererPanel.this.m_RunThread = null;
                            ClustererPanel.this.m_StartBut.setEnabled(true);
                            ClustererPanel.this.m_StopBut.setEnabled(false);
                            ClustererPanel.this.m_ignoreBut.setEnabled(true);
                            if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                            }
                            throw throwable;
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    private Instances removeClass(Instances inst) {
        Remove af = new Remove();
        Instances retI = null;
        try {
            if (inst.classIndex() < 0) {
                retI = inst;
            } else {
                af.setAttributeIndices("" + (inst.classIndex() + 1));
                af.setInvertSelection(false);
                af.setInputFormat(inst);
                retI = Filter.useFilter(inst, af);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retI;
    }

    private Instances removeIgnoreCols(Instances inst) {
        int classIndex;
        if (this.m_ClassesToClustersBut.isSelected() && this.m_ignoreKeyList.isSelectedIndex(classIndex = this.m_ClassCombo.getSelectedIndex())) {
            this.m_ignoreKeyList.removeSelectionInterval(classIndex, classIndex);
        }
        int[] selected = this.m_ignoreKeyList.getSelectedIndices();
        Remove af = new Remove();
        Instances retI = null;
        try {
            af.setAttributeIndicesArray(selected);
            af.setInvertSelection(false);
            af.setInputFormat(inst);
            retI = Filter.useFilter(inst, af);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retI;
    }

    private Instances removeIgnoreCols(Instances inst, int[] toIgnore) {
        Remove af = new Remove();
        Instances retI = null;
        try {
            af.setAttributeIndicesArray(toIgnore);
            af.setInvertSelection(false);
            af.setInputFormat(inst);
            retI = Filter.useFilter(inst, af);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retI;
    }

    protected void stopClusterer() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void visualizeTree(String graphString, String treeName) {
        StringBuilder stringBuilder = new StringBuilder();
        Messages.getInstance();
        final JFrame jf = new JFrame(stringBuilder.append(Messages.getString("ClustererPanel_VisualizeTree_JFrame_Text")).append(treeName).toString());
        jf.setSize(500, 400);
        jf.getContentPane().setLayout(new BorderLayout());
        if (graphString.contains("digraph")) {
            TreeVisualizer tv = new TreeVisualizer(null, graphString, (NodePlace)new PlaceNode2());
            jf.getContentPane().add((Component)tv, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.setVisible(true);
            tv.fitToScreen();
        } else {
            Messages.getInstance();
            if (graphString.startsWith(Messages.getString("ClustererPanel_VisualizeTree_GraphStringStartsWith_Text"))) {
                HierarchyVisualizer tv = new HierarchyVisualizer(graphString.substring(7));
                jf.getContentPane().add((Component)tv, "Center");
                jf.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        jf.dispose();
                    }
                });
                jf.setVisible(true);
                tv.fitToScreen();
            }
        }
    }

    protected void visualizeClusterAssignments(VisualizePanel sp) {
        if (sp != null) {
            String plotName = sp.getName();
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            final JFrame jf = new JFrame(stringBuilder.append(Messages.getString("ClustererPanel_VisualizeClusterAssignments_JFrame_Text")).append(plotName).toString());
            jf.setSize(500, 400);
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.setVisible(true);
        }
    }

    protected void visualizeClusterer(String name, int x, int y) {
        final String selectedName = name;
        JPopupMenu resultListMenu = new JPopupMenu();
        Messages.getInstance();
        JMenuItem visMainBuffer = new JMenuItem(Messages.getString("ClustererPanel_VisualizeClusterer_VisMainBuffer_JMenuItem_Text"));
        if (selectedName != null) {
            visMainBuffer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.m_History.setSingle(selectedName);
                }
            });
        } else {
            visMainBuffer.setEnabled(false);
        }
        resultListMenu.add(visMainBuffer);
        Messages.getInstance();
        JMenuItem visSepBuffer = new JMenuItem(Messages.getString("ClustererPanel_VisualizeClusterer_VisSepBuffer_JMenuItem_Text"));
        if (selectedName != null) {
            visSepBuffer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.m_History.openFrame(selectedName);
                }
            });
        } else {
            visSepBuffer.setEnabled(false);
        }
        resultListMenu.add(visSepBuffer);
        Messages.getInstance();
        JMenuItem saveOutput = new JMenuItem(Messages.getString("ClustererPanel_VisualizeClusterer_SaveOutput_JMenuItem_Text"));
        if (selectedName != null) {
            saveOutput.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.saveBuffer(selectedName);
                }
            });
        } else {
            saveOutput.setEnabled(false);
        }
        resultListMenu.add(saveOutput);
        Messages.getInstance();
        JMenuItem deleteOutput = new JMenuItem(Messages.getString("ClustererPanel_VisualizeClusterer_DeleteOutput_JMenuItem_Text"));
        if (selectedName != null) {
            deleteOutput.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.m_History.removeResult(selectedName);
                }
            });
        } else {
            deleteOutput.setEnabled(false);
        }
        resultListMenu.add(deleteOutput);
        resultListMenu.addSeparator();
        Messages.getInstance();
        JMenuItem loadModel = new JMenuItem(Messages.getString("ClustererPanel_VisualizeClusterer_LoadModel_JMenuItem_Text"));
        loadModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClustererPanel.this.loadClusterer();
            }
        });
        resultListMenu.add(loadModel);
        FastVector o = null;
        if (selectedName != null) {
            o = (FastVector)this.m_History.getNamedObject(selectedName);
        }
        VisualizePanel temp_vp = null;
        String temp_grph = null;
        Clusterer temp_clusterer = null;
        Instances temp_trainHeader = null;
        int[] temp_ignoreAtts = null;
        if (o != null) {
            for (int i = 0; i < o.size(); ++i) {
                Object temp = o.elementAt(i);
                if (temp instanceof Clusterer) {
                    temp_clusterer = (Clusterer)temp;
                    continue;
                }
                if (temp instanceof Instances) {
                    temp_trainHeader = (Instances)temp;
                    continue;
                }
                if (temp instanceof int[]) {
                    temp_ignoreAtts = (int[])temp;
                    continue;
                }
                if (temp instanceof VisualizePanel) {
                    temp_vp = (VisualizePanel)temp;
                    continue;
                }
                if (!(temp instanceof String)) continue;
                temp_grph = (String)temp;
            }
        }
        final VisualizePanel vp = temp_vp;
        final String grph = temp_grph;
        final Clusterer clusterer = temp_clusterer;
        final Instances trainHeader = temp_trainHeader;
        final int[] ignoreAtts = temp_ignoreAtts;
        Messages.getInstance();
        JMenuItem saveModel = new JMenuItem(Messages.getString("ClustererPanel_VisualizeClusterer_SaveModel_JMenuItem_Text"));
        if (clusterer != null) {
            saveModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.saveClusterer(selectedName, clusterer, trainHeader, ignoreAtts);
                }
            });
        } else {
            saveModel.setEnabled(false);
        }
        resultListMenu.add(saveModel);
        Messages.getInstance();
        JMenuItem reEvaluate = new JMenuItem(Messages.getString("ClustererPanel_VisualizeClusterer_ReEvaluate_JMenuItem_Text"));
        if (clusterer != null && this.m_TestInstances != null) {
            reEvaluate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.reevaluateModel(selectedName, clusterer, trainHeader, ignoreAtts);
                }
            });
        } else {
            reEvaluate.setEnabled(false);
        }
        resultListMenu.add(reEvaluate);
        resultListMenu.addSeparator();
        Messages.getInstance();
        JMenuItem visClusts = new JMenuItem(Messages.getString("ClustererPanel_VisualizeClusterer_VisClusts_JMenuItem_Text"));
        if (vp != null) {
            visClusts.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.visualizeClusterAssignments(vp);
                }
            });
        } else {
            visClusts.setEnabled(false);
        }
        resultListMenu.add(visClusts);
        Messages.getInstance();
        JMenuItem visTree = new JMenuItem(Messages.getString("ClustererPanel_VisualizeClusterer_VisTree_JMenuItem_Text"));
        if (grph != null) {
            visTree.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String title = vp != null ? vp.getName() : selectedName;
                    ClustererPanel.this.visualizeTree(grph, title);
                }
            });
        } else {
            visTree.setEnabled(false);
        }
        resultListMenu.add(visTree);
        resultListMenu.show(this.m_History.getList(), x, y);
    }

    protected void saveBuffer(String name) {
        StringBuffer sb = this.m_History.getNamedBuffer(name);
        if (sb != null && this.m_SaveOut.save(sb)) {
            Messages.getInstance();
            this.m_Log.logMessage(Messages.getString("ClustererPanel_VisualizeClusterer_SaveBuffer_Log_LohMessage_Text"));
        }
    }

    private void setIgnoreColumns() {
        ListSelectorDialog jd = new ListSelectorDialog(null, this.m_ignoreKeyList);
        int result = jd.showDialog();
        if (result != 0) {
            this.m_ignoreKeyList.clearSelection();
        }
        this.updateCapabilitiesFilter(this.m_ClustererEditor.getCapabilitiesFilter());
    }

    protected void saveClusterer(String name, Clusterer clusterer, Instances trainHeader, int[] ignoredAtts) {
        File sFile = null;
        boolean saveOK = true;
        int returnVal = this.m_FileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            sFile = this.m_FileChooser.getSelectedFile();
            if (!sFile.getName().toLowerCase().endsWith(MODEL_FILE_EXTENSION)) {
                sFile = new File(sFile.getParent(), sFile.getName() + MODEL_FILE_EXTENSION);
            }
            Messages.getInstance();
            this.m_Log.statusMessage(Messages.getString("ClustererPanel_VisualizeClusterer_SaveBuffer_Log_LohMessage_Text_Alpha"));
            try {
                OutputStream os = new FileOutputStream(sFile);
                if (sFile.getName().endsWith(".gz")) {
                    os = new GZIPOutputStream(os);
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(os);
                objectOutputStream.writeObject(clusterer);
                if (trainHeader != null) {
                    objectOutputStream.writeObject(trainHeader);
                }
                if (ignoredAtts != null) {
                    objectOutputStream.writeObject(ignoredAtts);
                }
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception e) {
                Messages.getInstance();
                JOptionPane.showMessageDialog(null, e, Messages.getString("ClustererPanel_VisualizeClusterer_SaveCluster_JOptionPaneShowMessageDialog_Text"), 0);
                saveOK = false;
            }
            if (saveOK) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("ClustererPanel_VisualizeClusterer_SaveCluster_Log_LogMessage_Text")).append(name);
                Messages.getInstance();
                this.m_Log.logMessage(stringBuilder2.append(Messages.getString("ClustererPanel_VisualizeClusterer_SaveCluster_Log_LogMessage_Text_Alpha")).append(sFile.getName()).append("'").toString());
            }
            Messages.getInstance();
            this.m_Log.statusMessage(Messages.getString("ClustererPanel_VisualizeClusterer_SaveCluster_Log_StatusMessage_Text"));
        }
    }

    protected void loadClusterer() {
        int returnVal = this.m_FileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selected = this.m_FileChooser.getSelectedFile();
            Clusterer clusterer = null;
            Instances trainHeader = null;
            int[] ignoredAtts = null;
            Messages.getInstance();
            this.m_Log.statusMessage(Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_Log_StatusSessage_Text_First"));
            try {
                InputStream is = new FileInputStream(selected);
                if (selected.getName().endsWith(".gz")) {
                    is = new GZIPInputStream(is);
                }
                ObjectInputStream objectInputStream = new ObjectInputStream(is);
                clusterer = (Clusterer)objectInputStream.readObject();
                try {
                    trainHeader = (Instances)objectInputStream.readObject();
                    ignoredAtts = (int[])objectInputStream.readObject();
                }
                catch (Exception e) {
                    // empty catch block
                }
                objectInputStream.close();
            }
            catch (Exception e) {
                Messages.getInstance();
                JOptionPane.showMessageDialog(null, e, Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_JOptionPaneShowMessageDialog_Text"), 0);
            }
            Messages.getInstance();
            this.m_Log.statusMessage(Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_Log_StatusMessage_Text_Second"));
            if (clusterer != null) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                this.m_Log.logMessage(stringBuilder.append(Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_Log_LogMessage_Text_First")).append(selected.getName()).append("'").toString());
                String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                String cname = clusterer.getClass().getName();
                if (cname.startsWith("weka.clusterers.")) {
                    cname = cname.substring("weka.clusterers.".length());
                }
                StringBuilder stringBuilder2 = new StringBuilder().append(name).append(cname);
                Messages.getInstance();
                name = stringBuilder2.append(Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_CNAme_Text_First")).append(selected.getName()).append("'").toString();
                StringBuffer outBuff = new StringBuffer();
                Messages.getInstance();
                outBuff.append(Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_OutBuffer_Text_First"));
                StringBuilder stringBuilder3 = new StringBuilder();
                Messages.getInstance();
                outBuff.append(stringBuilder3.append(Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_OutBuffer_Text_Second")).append(selected.getName()).append("\n").toString());
                StringBuilder stringBuilder4 = new StringBuilder();
                Messages.getInstance();
                outBuff.append(stringBuilder4.append(Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_OutBuffer_Text_Fourth")).append(clusterer.getClass().getName()).toString());
                if (clusterer instanceof OptionHandler) {
                    String[] o = ((OptionHandler)((Object)clusterer)).getOptions();
                    outBuff.append(" " + Utils.joinOptions(o));
                }
                outBuff.append("\n");
                if (trainHeader != null) {
                    StringBuilder stringBuilder5 = new StringBuilder();
                    Messages.getInstance();
                    outBuff.append(stringBuilder5.append(Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_OutBuffer_Text_Sixth")).append(trainHeader.relationName()).append('\n').toString());
                    StringBuilder stringBuilder6 = new StringBuilder();
                    Messages.getInstance();
                    outBuff.append(stringBuilder6.append(Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_OutBuffer_Text_Eighth")).append(trainHeader.numAttributes()).append('\n').toString());
                    if (trainHeader.numAttributes() < 100) {
                        int i;
                        boolean[] selectedAtts = new boolean[trainHeader.numAttributes()];
                        for (i = 0; i < trainHeader.numAttributes(); ++i) {
                            selectedAtts[i] = true;
                        }
                        if (ignoredAtts != null) {
                            for (i = 0; i < ignoredAtts.length; ++i) {
                                selectedAtts[ignoredAtts[i]] = false;
                            }
                        }
                        for (i = 0; i < trainHeader.numAttributes(); ++i) {
                            if (!selectedAtts[i]) continue;
                            outBuff.append("              " + trainHeader.attribute(i).name() + '\n');
                        }
                        if (ignoredAtts != null) {
                            Messages.getInstance();
                            outBuff.append(Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_OutBuffer_Text_Eleventh"));
                            for (i = 0; i < ignoredAtts.length; ++i) {
                                outBuff.append("              " + trainHeader.attribute(ignoredAtts[i]).name() + '\n');
                            }
                        }
                    } else {
                        Messages.getInstance();
                        outBuff.append(Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_OutBuffer_Text_Twelveth"));
                    }
                } else {
                    Messages.getInstance();
                    outBuff.append(Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_OutBuffer_Text_Thirteenth"));
                }
                Messages.getInstance();
                outBuff.append(Messages.getString("ClustererPanel_VisualizeClusterer_LoadClusterer_OutBuffer_Text_Fourteenth"));
                outBuff.append(clusterer.toString() + "\n");
                this.m_History.addResult(name, outBuff);
                this.m_History.setSingle(name);
                FastVector vv = new FastVector();
                vv.addElement(clusterer);
                if (trainHeader != null) {
                    vv.addElement(trainHeader);
                }
                if (ignoredAtts != null) {
                    vv.addElement(ignoredAtts);
                }
                String grph = null;
                if (clusterer instanceof Drawable) {
                    try {
                        grph = ((Drawable)((Object)clusterer)).graph();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (grph != null) {
                    vv.addElement(grph);
                }
                this.m_History.addObject(name, vv);
            }
        }
    }

    protected void reevaluateModel(final String name, final Clusterer clusterer, final Instances trainHeader, final int[] ignoredAtts) {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_ignoreBut.setEnabled(false);
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block37: {
                        Object grph;
                        boolean saveVis;
                        PlotData2D predData;
                        Instances userTest;
                        block34: {
                            Logger logger = ClustererPanel.this.m_Log;
                            Messages.getInstance();
                            logger.statusMessage(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_StatusMessage_Text_First"));
                            StringBuffer outBuff = ClustererPanel.this.m_History.getNamedBuffer(name);
                            userTest = null;
                            predData = null;
                            if (ClustererPanel.this.m_TestInstances != null) {
                                userTest = new Instances(ClustererPanel.this.m_TestInstances);
                            }
                            saveVis = ClustererPanel.this.m_StorePredictionsBut.isSelected();
                            grph = null;
                            if (userTest == null) {
                                Messages.getInstance();
                                throw new Exception(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Exception_Text_First"));
                            }
                            if (trainHeader != null && !trainHeader.equalHeaders(userTest)) {
                                Messages.getInstance();
                                throw new Exception(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Exception_Text_Second"));
                            }
                            Logger logger2 = ClustererPanel.this.m_Log;
                            Messages.getInstance();
                            logger2.statusMessage(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_StatusMessage_Text_Second"));
                            Logger logger3 = ClustererPanel.this.m_Log;
                            StringBuilder stringBuilder = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_LogMessage_Text_First")).append(name);
                            Messages.getInstance();
                            logger3.logMessage(stringBuilder2.append(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_LogMessage_Text_Second")).toString());
                            Logger logger4 = ClustererPanel.this.m_Log;
                            Messages.getInstance();
                            logger4.logMessage(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_LogMessage_Text_Third"));
                            if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskStarted();
                            }
                            ClusterEvaluation eval = new ClusterEvaluation();
                            eval.setClusterer(clusterer);
                            Instances userTestT = new Instances(userTest);
                            if (ignoredAtts != null) {
                                userTestT = ClustererPanel.this.removeIgnoreCols(userTestT, ignoredAtts);
                            }
                            eval.evaluateClusterer(userTestT);
                            predData = ClustererPanel.setUpVisualizableInstances(userTest, eval);
                            Messages.getInstance();
                            outBuff.append(Messages.getString("ClustererPanel_ReEvaluateModel_Run_OutBuffer_Text_First"));
                            Messages.getInstance();
                            outBuff.append(Messages.getString("ClustererPanel_ReEvaluateModel_Run_OutBuffer_Text_Second"));
                            StringBuilder stringBuilder3 = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder4 = stringBuilder3.append(Messages.getString("ClustererPanel_ReEvaluateModel_Run_OutBuffer_Text_Third")).append(userTest.relationName());
                            Messages.getInstance();
                            outBuff.append(stringBuilder4.append(Messages.getString("ClustererPanel_ReEvaluateModel_Run_OutBuffer_Text_Fourth")).toString());
                            StringBuilder stringBuilder5 = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder6 = stringBuilder5.append(Messages.getString("ClustererPanel_ReEvaluateModel_Run_OutBuffer_Text_Fifth")).append(userTest.numInstances());
                            Messages.getInstance();
                            outBuff.append(stringBuilder6.append(Messages.getString("ClustererPanel_ReEvaluateModel_Run_OutBuffer_Text_Sixth")).toString());
                            StringBuilder stringBuilder7 = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder8 = stringBuilder7.append(Messages.getString("ClustererPanel_ReEvaluateModel_Run_OutBuffer_Text_Seventh")).append(userTest.numAttributes());
                            Messages.getInstance();
                            outBuff.append(stringBuilder8.append(Messages.getString("ClustererPanel_ReEvaluateModel_Run_OutBuffer_Text_Eighth")).toString());
                            if (trainHeader == null) {
                                Messages.getInstance();
                                outBuff.append(Messages.getString("ClustererPanel_ReEvaluateModel_Run_OutBuffer_Text_Nineth"));
                            }
                            outBuff.append(eval.clusterResultsToString());
                            Messages.getInstance();
                            outBuff.append(Messages.getString("ClustererPanel_ReEvaluateModel_Run_OutBuffer_Text_Tenth"));
                            ClustererPanel.this.m_History.updateResult(name);
                            Logger logger5 = ClustererPanel.this.m_Log;
                            Messages.getInstance();
                            logger5.logMessage(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_LogMessage_Text_Fourth"));
                            Logger logger6 = ClustererPanel.this.m_Log;
                            Messages.getInstance();
                            logger6.statusMessage(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_StatusMessage_Text_Third"));
                            Object var9_9 = null;
                            if (predData == null) break block34;
                            ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                            ClustererPanel.this.m_CurrentVis.setName(name + " (" + userTest.relationName() + ")");
                            ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                            predData.setPlotName(name + " (" + userTest.relationName() + ")");
                            try {
                                ClustererPanel.this.m_CurrentVis.addPlot(predData);
                            }
                            catch (Exception ex2) {
                                System.err.println(ex2);
                            }
                            FastVector vv = new FastVector();
                            vv.addElement(clusterer);
                            if (trainHeader != null) {
                                vv.addElement(trainHeader);
                            }
                            if (ignoredAtts != null) {
                                vv.addElement(ignoredAtts);
                            }
                            if (saveVis) {
                                vv.addElement(ClustererPanel.this.m_CurrentVis);
                                if (grph != null) {
                                    vv.addElement(grph);
                                }
                            }
                            ClustererPanel.this.m_History.addObject(name, vv);
                        }
                        if (this.isInterrupted()) {
                            Logger logger = ClustererPanel.this.m_Log;
                            Messages.getInstance();
                            logger.logMessage(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_LogMessage_Text_Fifth"));
                            Logger logger7 = ClustererPanel.this.m_Log;
                            Messages.getInstance();
                            logger7.statusMessage(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_StatusMessage_Text_Fifth"));
                        }
                        ClustererPanel.this.m_RunThread = null;
                        ClustererPanel.this.m_StartBut.setEnabled(true);
                        ClustererPanel.this.m_StopBut.setEnabled(false);
                        ClustererPanel.this.m_ignoreBut.setEnabled(true);
                        if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                        }
                        break block37;
                        {
                            catch (Exception ex) {
                                ex.printStackTrace();
                                ClustererPanel.this.m_Log.logMessage(ex.getMessage());
                                StringBuilder stringBuilder = new StringBuilder();
                                Messages.getInstance();
                                String string = stringBuilder.append(Messages.getString("ClustererPanel_ReEvaluateModel_Run_JOptionPaneShowMessageDialog_Text_First")).append(ex.getMessage()).toString();
                                Messages.getInstance();
                                JOptionPane.showMessageDialog(ClustererPanel.this, string, Messages.getString("ClustererPanel_ReEvaluateModel_Run_JOptionPaneShowMessageDialog_Text_Second"), 0);
                                Logger logger = ClustererPanel.this.m_Log;
                                Messages.getInstance();
                                logger.statusMessage(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_StatusMessage_Text_Fourth"));
                                Object var9_10 = null;
                                if (predData != null) {
                                    ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                                    ClustererPanel.this.m_CurrentVis.setName(name + " (" + userTest.relationName() + ")");
                                    ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                                    predData.setPlotName(name + " (" + userTest.relationName() + ")");
                                    try {
                                        ClustererPanel.this.m_CurrentVis.addPlot(predData);
                                    }
                                    catch (Exception ex2) {
                                        System.err.println(ex2);
                                    }
                                    FastVector vv = new FastVector();
                                    vv.addElement(clusterer);
                                    if (trainHeader != null) {
                                        vv.addElement(trainHeader);
                                    }
                                    if (ignoredAtts != null) {
                                        vv.addElement(ignoredAtts);
                                    }
                                    if (saveVis) {
                                        vv.addElement(ClustererPanel.this.m_CurrentVis);
                                        if (grph != null) {
                                            vv.addElement(grph);
                                        }
                                    }
                                    ClustererPanel.this.m_History.addObject(name, vv);
                                }
                                if (this.isInterrupted()) {
                                    Logger logger8 = ClustererPanel.this.m_Log;
                                    Messages.getInstance();
                                    logger8.logMessage(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_LogMessage_Text_Fifth"));
                                    Logger logger9 = ClustererPanel.this.m_Log;
                                    Messages.getInstance();
                                    logger9.statusMessage(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_StatusMessage_Text_Fifth"));
                                }
                                ClustererPanel.this.m_RunThread = null;
                                ClustererPanel.this.m_StartBut.setEnabled(true);
                                ClustererPanel.this.m_StopBut.setEnabled(false);
                                ClustererPanel.this.m_ignoreBut.setEnabled(true);
                                if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                    ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_11 = null;
                            if (predData != null) {
                                ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                                ClustererPanel.this.m_CurrentVis.setName(name + " (" + userTest.relationName() + ")");
                                ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                                predData.setPlotName(name + " (" + userTest.relationName() + ")");
                                try {
                                    ClustererPanel.this.m_CurrentVis.addPlot(predData);
                                }
                                catch (Exception ex2) {
                                    System.err.println(ex2);
                                }
                                FastVector vv = new FastVector();
                                vv.addElement(clusterer);
                                if (trainHeader != null) {
                                    vv.addElement(trainHeader);
                                }
                                if (ignoredAtts != null) {
                                    vv.addElement(ignoredAtts);
                                }
                                if (saveVis) {
                                    vv.addElement(ClustererPanel.this.m_CurrentVis);
                                    if (grph != null) {
                                        vv.addElement(grph);
                                    }
                                }
                                ClustererPanel.this.m_History.addObject(name, vv);
                            }
                            if (this.isInterrupted()) {
                                Logger logger = ClustererPanel.this.m_Log;
                                Messages.getInstance();
                                logger.logMessage(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_LogMessage_Text_Fifth"));
                                Logger logger10 = ClustererPanel.this.m_Log;
                                Messages.getInstance();
                                logger10.statusMessage(Messages.getString("ClustererPanel_ReEvaluateModel_Run_Log_StatusMessage_Text_Fifth"));
                            }
                            ClustererPanel.this.m_RunThread = null;
                            ClustererPanel.this.m_StartBut.setEnabled(true);
                            ClustererPanel.this.m_StopBut.setEnabled(false);
                            ClustererPanel.this.m_ignoreBut.setEnabled(true);
                            if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                            }
                            throw throwable;
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void updateCapabilitiesFilter(Capabilities filter) {
        Capabilities filterClass;
        if (filter == null) {
            this.m_ClustererEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances tempInst = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        tempInst.setClassIndex(-1);
        if (!this.m_ignoreKeyList.isSelectionEmpty()) {
            tempInst = this.removeIgnoreCols(tempInst);
        }
        if (this.m_ClassesToClustersBut.isSelected()) {
            String classSelection = this.m_ClassCombo.getSelectedItem().toString();
            classSelection = classSelection.substring(classSelection.indexOf(")") + 1).trim();
            int classIndex = tempInst.attribute(classSelection).index();
            Remove rm = new Remove();
            rm.setAttributeIndices("" + (classIndex + 1));
            try {
                rm.setInputFormat(tempInst);
                tempInst = Filter.useFilter(tempInst, rm);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            filterClass = Capabilities.forInstances(tempInst);
        }
        catch (Exception e) {
            filterClass = new Capabilities(null);
        }
        this.m_ClustererEditor.setCapabilitiesFilter(filterClass);
        this.m_StartBut.setEnabled(true);
        Capabilities currentFilter = this.m_ClustererEditor.getCapabilitiesFilter();
        Clusterer clusterer = (Clusterer)this.m_ClustererEditor.getValue();
        Capabilities currentSchemeCapabilities = null;
        if (clusterer != null && currentFilter != null && clusterer instanceof CapabilitiesHandler && !(currentSchemeCapabilities = ((CapabilitiesHandler)((Object)clusterer)).getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
            this.m_StartBut.setEnabled(false);
        }
    }

    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent e) {
        if (e.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)e.getFilter().clone());
        }
    }

    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    public String getTabTitle() {
        Messages.getInstance();
        return Messages.getString("ClustererPanel_GetTabTitle_Text");
    }

    public String getTabTitleToolTip() {
        Messages.getInstance();
        return Messages.getString("ClustererPanel_GetTabTitleToolTip_Text");
    }

    public static void main(String[] args) {
        try {
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("ClustererPanel_Main_JFrame_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            ClustererPanel sp = new ClustererPanel();
            jf.getContentPane().add((Component)sp, "Center");
            LogPanel lp = new LogPanel();
            sp.setLog(lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
            if (args.length == 1) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                System.err.println(stringBuilder.append(Messages.getString("ClustererPanel_Main_Error_Text_First")).append(args[0]).toString());
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances(r);
                sp.setInstances(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

