/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import weka.experiment.Experiment;
import weka.experiment.RemoteExperiment;
import weka.gui.experiment.HostListPanel;

public class DistributeExperimentPanel
extends JPanel {
    private static final long serialVersionUID = 5206721431754800278L;
    RemoteExperiment m_Exp = null;
    protected JCheckBox m_enableDistributedExperiment = new JCheckBox();
    protected JButton m_configureHostNames = new JButton("Hosts");
    protected HostListPanel m_hostList = new HostListPanel();
    protected JRadioButton m_splitByDataSet = new JRadioButton("By data set");
    protected JRadioButton m_splitByRun = new JRadioButton("By run");
    protected JRadioButton m_splitByProperty = new JRadioButton("By property");
    ActionListener m_radioListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DistributeExperimentPanel.this.updateRadioLinks();
        }
    };

    public DistributeExperimentPanel() {
        this.m_enableDistributedExperiment.setSelected(false);
        this.m_enableDistributedExperiment.setToolTipText("Allow this experiment to be distributed to remote hosts");
        this.m_enableDistributedExperiment.setEnabled(false);
        this.m_configureHostNames.setEnabled(false);
        this.m_configureHostNames.setToolTipText("Edit the list of remote hosts");
        this.m_enableDistributedExperiment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistributeExperimentPanel.this.m_configureHostNames.setEnabled(DistributeExperimentPanel.this.m_enableDistributedExperiment.isSelected());
                DistributeExperimentPanel.this.m_splitByDataSet.setEnabled(DistributeExperimentPanel.this.m_enableDistributedExperiment.isSelected());
                DistributeExperimentPanel.this.m_splitByRun.setEnabled(DistributeExperimentPanel.this.m_enableDistributedExperiment.isSelected());
                DistributeExperimentPanel.this.m_splitByProperty.setEnabled(DistributeExperimentPanel.this.m_enableDistributedExperiment.isSelected());
            }
        });
        this.m_configureHostNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistributeExperimentPanel.this.popupHostPanel();
            }
        });
        this.m_splitByDataSet.setToolTipText("Distribute experiment by data set");
        this.m_splitByRun.setToolTipText("Distribute experiment by run number");
        this.m_splitByProperty.setToolTipText("Distribute experiment by property");
        this.m_splitByDataSet.setSelected(true);
        this.m_splitByDataSet.setEnabled(false);
        this.m_splitByRun.setEnabled(false);
        this.m_splitByProperty.setEnabled(false);
        this.m_splitByDataSet.addActionListener(this.m_radioListener);
        this.m_splitByRun.addActionListener(this.m_radioListener);
        this.m_splitByProperty.addActionListener(this.m_radioListener);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_splitByDataSet);
        bg.add(this.m_splitByRun);
        bg.add(this.m_splitByProperty);
        JPanel rbuts = new JPanel();
        rbuts.setLayout(new GridLayout(1, 2));
        rbuts.add(this.m_splitByDataSet);
        rbuts.add(this.m_splitByRun);
        rbuts.add(this.m_splitByProperty);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Distribute experiment"));
        this.add((Component)this.m_enableDistributedExperiment, "West");
        this.add((Component)this.m_configureHostNames, "Center");
        this.add((Component)rbuts, "South");
    }

    public DistributeExperimentPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public void setExperiment(Experiment exp) {
        this.m_enableDistributedExperiment.setEnabled(true);
        this.m_Exp = null;
        if (exp instanceof RemoteExperiment) {
            this.m_Exp = (RemoteExperiment)exp;
            this.m_enableDistributedExperiment.setSelected(true);
            this.m_configureHostNames.setEnabled(true);
            this.m_hostList.setExperiment(this.m_Exp);
            this.m_splitByDataSet.setEnabled(true);
            this.m_splitByRun.setEnabled(true);
            this.m_splitByProperty.setEnabled(true);
            this.m_splitByDataSet.setSelected(this.m_Exp.getSplitByDataSet());
            this.m_splitByRun.setSelected(!this.m_Exp.getSplitByDataSet() && !this.m_Exp.getSplitByProperty());
            this.m_splitByProperty.setSelected(this.m_Exp.getSplitByProperty());
        }
    }

    private void popupHostPanel() {
        try {
            final JFrame jf = new JFrame("Edit host names");
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)this.m_hostList, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public boolean distributedExperimentSelected() {
        return this.m_enableDistributedExperiment.isSelected();
    }

    public void addCheckBoxActionListener(ActionListener al) {
        this.m_enableDistributedExperiment.addActionListener(al);
    }

    private void updateRadioLinks() {
        if (this.m_Exp != null) {
            this.m_Exp.setSplitByDataSet(this.m_splitByDataSet.isSelected());
            this.m_Exp.setSplitByProperty(this.m_splitByProperty.isSelected());
        }
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("DistributeExperiment");
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)new DistributeExperimentPanel(new Experiment()), "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

