/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdbc;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.Resource;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.AbstractGpsDevice;
import org.compass.gps.device.jdbc.JdbcGpsDevice;
import org.compass.gps.device.jdbc.JdbcGpsDeviceException;
import org.compass.gps.device.jdbc.JdbcUtils;
import org.compass.gps.device.jdbc.dialect.DefaultJdbcDialect;
import org.compass.gps.device.jdbc.dialect.JdbcDialect;

public abstract class AbstractJdbcGpsDevice
extends AbstractGpsDevice
implements JdbcGpsDevice {
    protected Log log = LogFactory.getLog(this.getClass());
    protected DataSource dataSource;
    protected JdbcDialect dialect = new DefaultJdbcDialect();
    private int fetchSize = 0;

    protected void doStart() throws CompassGpsException {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("dataSource property must be set");
        }
    }

    protected void doIndex(CompassSession session) throws CompassGpsException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("{" + this.getName() + "}: Indexing the database with fetch size [" + this.fetchSize + "]"));
        }
        Connection connection = JdbcUtils.getConnection(this.dataSource);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            IndexExecution[] indexExecutions = this.doGetIndexExecutions(connection);
            for (int i = 0; i < indexExecutions.length; ++i) {
                IndexExecution indexExecution = indexExecutions[i];
                ps = indexExecution.getStatement();
                if (ps == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("{" + this.getName() + "} Executing select query [" + indexExecution.getStatementQuery() + "]"));
                    }
                    ps = connection.prepareStatement(indexExecution.getStatementQuery());
                }
                if (this.getFetchSize() > 0) {
                    ps.setFetchSize(this.getFetchSize());
                }
                rs = ps.executeQuery();
                this.processResultSet(indexExecution.getDescription(), rs, session);
            }
        }
        catch (CompassException e) {
            this.log.error((Object)"Failed to index database", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to index database", (Throwable)e);
            throw new JdbcGpsDeviceException("Failed to index database", e);
        }
        finally {
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement(ps);
            JdbcUtils.closeConnection(connection);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("{" + this.getName() + "}: Finished indexing the database"));
        }
    }

    protected void processResultSet(Object description, ResultSet rs, CompassSession session) throws SQLException, CompassException {
        while (rs.next()) {
            this.processRow(description, rs, session);
        }
    }

    protected void processRow(Object description, ResultSet rs, CompassSession session) throws SQLException, CompassException {
        Object value = this.processRowValue(description, rs, session);
        if (value != null) {
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    Object value1 = Array.get(value, i);
                    if (value1 instanceof Resource) {
                        session.create((Object)((Resource)value1));
                        continue;
                    }
                    session.create(value1);
                }
            } else if (value instanceof Resource) {
                session.create((Object)((Resource)value));
            } else {
                session.create(value);
            }
        }
    }

    protected Object processRowValue(Object description, ResultSet rs, CompassSession session) throws SQLException, CompassException {
        return null;
    }

    protected abstract IndexExecution[] doGetIndexExecutions(Connection var1) throws SQLException, JdbcGpsDeviceException;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public JdbcDialect getDialect() {
        return this.dialect;
    }

    public void setDialect(JdbcDialect dialect) {
        this.dialect = dialect;
    }

    public static class IndexExecution {
        private Object description;
        private PreparedStatement statement;
        private String statementQuery;

        public IndexExecution(Object description) {
            this.description = description;
        }

        public IndexExecution(Object description, String statementQuery) {
            this.description = description;
            this.statementQuery = statementQuery;
        }

        public IndexExecution(Object description, PreparedStatement statement) {
            this.description = description;
            this.statement = statement;
        }

        public Object getDescription() {
            return this.description;
        }

        public PreparedStatement getStatement() {
            return this.statement;
        }

        public String getStatementQuery() {
            return this.statementQuery;
        }

        public void setStatementQuery(String statementQuery) {
            this.statementQuery = statementQuery;
        }

        public void setStatement(PreparedStatement statement) {
            this.statement = statement;
        }

        public void setDescription(Object description) {
            this.description = description;
        }
    }
}

