/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.gps.device.jdbc.JdbcGpsDeviceException;

public abstract class JdbcUtils {
    private static Log log = LogFactory.getLog((Class)JdbcUtils.class);

    public static Connection getConnection(DataSource dataSource) throws JdbcGpsDeviceException {
        try {
            return dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new JdbcGpsDeviceException("Failed to open jdbc connection", e);
        }
    }

    public static void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                log.warn((Object)"Could not close JDBC Connection", (Throwable)ex);
            }
            catch (RuntimeException ex) {
                log.error((Object)"Unexpected exception on closing JDBC Connection", (Throwable)ex);
            }
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                log.warn((Object)"Could not close JDBC Statement", (Throwable)ex);
            }
            catch (RuntimeException ex) {
                log.error((Object)"Unexpected exception on closing JDBC Statement", (Throwable)ex);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                log.warn((Object)"Could not close JDBC ResultSet", (Throwable)ex);
            }
            catch (RuntimeException ex) {
                log.error((Object)"Unexpected exception on closing JDBC ResultSet", (Throwable)ex);
            }
        }
    }

    public static int getColumnIndexFromColumnName(ResultSetMetaData metaData, String columnName) throws SQLException {
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            String tmpName = metaData.getColumnLabel(i);
            if (!tmpName.equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }
}

