/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.Resource;
import org.compass.core.config.CommonMetaDataLookup;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.spi.InternalCompass;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.jdbc.AbstractJdbcActiveMirrorGpsDevice;
import org.compass.gps.device.jdbc.AbstractJdbcGpsDevice;
import org.compass.gps.device.jdbc.JdbcGpsDeviceException;
import org.compass.gps.device.jdbc.JdbcUtils;
import org.compass.gps.device.jdbc.ResultSetRowMarshallHelper;
import org.compass.gps.device.jdbc.mapping.AutoGenerateMapping;
import org.compass.gps.device.jdbc.mapping.ColumnMapping;
import org.compass.gps.device.jdbc.mapping.ColumnToPropertyMapping;
import org.compass.gps.device.jdbc.mapping.ResultSetToResourceMapping;
import org.compass.gps.device.jdbc.mapping.VersionColumnMapping;
import org.compass.gps.device.jdbc.snapshot.ConfigureSnapshotEvent;
import org.compass.gps.device.jdbc.snapshot.CreateAndUpdateSnapshotEvent;
import org.compass.gps.device.jdbc.snapshot.DeleteSnapshotEvent;
import org.compass.gps.device.jdbc.snapshot.JdbcAliasRowSnapshot;
import org.compass.gps.device.jdbc.snapshot.JdbcAliasSnapshot;
import org.compass.gps.device.jdbc.snapshot.JdbcSnapshot;

public class ResultSetJdbcGpsDevice
extends AbstractJdbcActiveMirrorGpsDevice {
    protected List mappings = new ArrayList();
    private JdbcSnapshot snapshot;
    private boolean autoDetectVersionColumnSqlType = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws CompassGpsException {
        Connection connection;
        ResultSetToResourceMapping rsMapping;
        super.doStart();
        Iterator it = this.mappings.iterator();
        while (it.hasNext()) {
            ResultSetToResourceMapping rsMapping2 = (ResultSetToResourceMapping)it.next();
            if (!(rsMapping2 instanceof AutoGenerateMapping)) continue;
            ((AutoGenerateMapping)((Object)rsMapping2)).generateMappings(this.dataSource);
        }
        CommonMetaDataLookup commonMetaDataLookup = new CommonMetaDataLookup(((InternalCompass)this.compassGps.getIndexCompass()).getMetaData());
        Iterator it2 = this.mappings.iterator();
        while (it2.hasNext()) {
            rsMapping = (ResultSetToResourceMapping)it2.next();
            rsMapping.setAlias(commonMetaDataLookup.lookupAliasName(rsMapping.getAlias()));
            Iterator it1 = rsMapping.mappingsIt();
            while (it1.hasNext()) {
                List columns = (List)it1.next();
                Iterator it22 = columns.iterator();
                while (it22.hasNext()) {
                    ColumnMapping columnMapping = (ColumnMapping)it22.next();
                    if (!(columnMapping instanceof ColumnToPropertyMapping)) continue;
                    ColumnToPropertyMapping columnToPropertyMapping = (ColumnToPropertyMapping)columnMapping;
                    columnToPropertyMapping.setPropertyName(commonMetaDataLookup.lookupMetaDataName(columnToPropertyMapping.getPropertyName()));
                }
            }
        }
        it2 = this.mappings.iterator();
        while (it2.hasNext()) {
            rsMapping = (ResultSetToResourceMapping)it2.next();
            if (!this.compassGps.hasMappingForEntityForMirror(rsMapping.getAlias(), CascadeMapping.Cascade.ALL)) {
                throw new IllegalStateException(this.buildMessage("No resource mapping defined in gps mirror compass for alias [" + rsMapping.getAlias() + "]. Did you defined a jdbc mapping builder?"));
            }
            if (this.compassGps.hasMappingForEntityForIndex(rsMapping.getAlias())) continue;
            throw new IllegalStateException(this.buildMessage("No resource mapping defined in gps index compass for alias [" + rsMapping.getAlias() + "]. Did you defined a jdbc mapping builder?"));
        }
        if (this.isAutoDetectVersionColumnSqlType()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)this.buildMessage("Auto detecting version column sql types"));
            }
            connection = JdbcUtils.getConnection(this.dataSource);
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                Iterator it3 = this.mappings.iterator();
                while (it3.hasNext()) {
                    ResultSetToResourceMapping mapping = (ResultSetToResourceMapping)it3.next();
                    if (!mapping.supportsVersioning()) continue;
                    ps = connection.prepareStatement(mapping.getVersionQuery());
                    ps.setFetchSize(1);
                    rs = ps.executeQuery();
                    ResultSetMetaData metaData = rs.getMetaData();
                    Iterator verIt = mapping.versionMappingsIt();
                    while (verIt.hasNext()) {
                        VersionColumnMapping versionMapping = (VersionColumnMapping)verIt.next();
                        int columnIndex = versionMapping.isUsingColumnIndex() ? versionMapping.getColumnIndex() : JdbcUtils.getColumnIndexFromColumnName(metaData, versionMapping.getColumnName());
                        versionMapping.setSqlType(metaData.getColumnType(columnIndex));
                    }
                }
            }
            catch (SQLException e) {
                throw new JdbcGpsDeviceException(this.buildMessage("Failed to find version column type"), e);
            }
            finally {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(connection);
            }
        }
        if (this.isMirrorDataChanges()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)this.buildMessage("Using mirroring, loading snapshot data"));
            }
            this.snapshot = this.getSnapshotPersister().load();
            it2 = this.mappings.iterator();
            while (it2.hasNext()) {
                ResultSetToResourceMapping mapping = (ResultSetToResourceMapping)it2.next();
                if (!mapping.supportsVersioning() || this.snapshot.getAliasSnapshot(mapping.getAlias()) != null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)this.buildMessage("Alias [" + mapping.getAlias() + "] not found in snapshot data, creating..."));
                }
                JdbcAliasSnapshot aliasSnapshot = new JdbcAliasSnapshot(mapping.getAlias());
                this.snapshot.putAliasSnapshot(aliasSnapshot);
            }
            connection = JdbcUtils.getConnection(this.dataSource);
            try {
                this.getSnapshotEventListener().configure(new ConfigureSnapshotEvent(connection, this.dialect, this.mappings));
            }
            finally {
                JdbcUtils.closeConnection(connection);
            }
        }
        if (this.log.isDebugEnabled()) {
            it2 = this.mappings.iterator();
            while (it2.hasNext()) {
                this.log.debug((Object)this.buildMessage("Using DB Mapping " + it2.next()));
            }
        }
    }

    protected void doStop() throws CompassGpsException {
        this.getSnapshotPersister().save(this.snapshot);
        super.doStop();
    }

    protected void doIndex(CompassSession session) throws CompassGpsException {
        this.snapshot = new JdbcSnapshot();
        Iterator it = this.mappings.iterator();
        while (it.hasNext()) {
            ResultSetToResourceMapping mapping = (ResultSetToResourceMapping)it.next();
            if (!mapping.supportsVersioning()) continue;
            JdbcAliasSnapshot aliasSnapshot = new JdbcAliasSnapshot(mapping.getAlias());
            this.snapshot.putAliasSnapshot(aliasSnapshot);
        }
        super.doIndex(session);
        this.getSnapshotPersister().save(this.snapshot);
    }

    protected AbstractJdbcGpsDevice.IndexExecution[] doGetIndexExecutions(Connection connection) throws SQLException, JdbcGpsDeviceException {
        AbstractJdbcGpsDevice.IndexExecution[] indexExecutions = new AbstractJdbcGpsDevice.IndexExecution[this.mappings.size()];
        for (int i = 0; i < indexExecutions.length; ++i) {
            ResultSetToResourceMapping mapping = (ResultSetToResourceMapping)this.mappings.get(i);
            indexExecutions[i] = new AbstractJdbcGpsDevice.IndexExecution((Object)mapping, mapping.getSelectQuery());
        }
        return indexExecutions;
    }

    protected Object processRowValue(Object description, ResultSet rs, CompassSession session) throws SQLException, CompassException {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.buildMessage("Indexing data row with values "));
            ResultSetMetaData metaData = rs.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                sb.append("[").append(metaData.getColumnName(i)).append(":");
                String value = rs.getString(i);
                if (rs.wasNull()) {
                    value = "(null)";
                }
                sb.append(value);
                sb.append("] ");
            }
            this.log.debug((Object)sb.toString());
        }
        ResultSetToResourceMapping mapping = (ResultSetToResourceMapping)description;
        JdbcAliasRowSnapshot rowSnapshot = null;
        if (this.shouldMirrorDataChanges() && mapping.supportsVersioning()) {
            rowSnapshot = new JdbcAliasRowSnapshot();
        }
        Resource resource = session.createResource(mapping.getAlias());
        ResultSetRowMarshallHelper marshallHelper = new ResultSetRowMarshallHelper(mapping, session, this.dialect, resource, rowSnapshot);
        marshallHelper.marshallResultSet(rs);
        if (this.shouldMirrorDataChanges() && mapping.supportsVersioning()) {
            this.snapshot.getAliasSnapshot(mapping.getAlias()).putRow(rowSnapshot);
        }
        return resource;
    }

    public synchronized void performMirroring() throws JdbcGpsDeviceException {
        if (!this.shouldMirrorDataChanges() || this.isPerformingIndexOperation()) {
            return;
        }
        if (this.snapshot == null) {
            throw new IllegalStateException(this.buildMessage("Versioning data was not properly initialized, did you index the device or loaded the data?"));
        }
        Connection connection = JdbcUtils.getConnection(this.dataSource);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Iterator it = this.mappings.iterator();
            while (it.hasNext()) {
                ResultSetToResourceMapping mapping = (ResultSetToResourceMapping)it.next();
                if (!mapping.supportsVersioning()) continue;
                JdbcAliasSnapshot oldAliasSnapshot = this.snapshot.getAliasSnapshot(mapping.getAlias());
                if (oldAliasSnapshot == null) {
                    this.log.warn((Object)this.buildMessage("No snapshot for alias [" + mapping.getAlias() + "] even though there should be support for versioning ignoring the alias"));
                    continue;
                }
                JdbcAliasSnapshot newAliasSnapshot = new JdbcAliasSnapshot(mapping.getAlias());
                ArrayList<JdbcAliasRowSnapshot> createdRows = new ArrayList<JdbcAliasRowSnapshot>();
                ArrayList<JdbcAliasRowSnapshot> updatedRows = new ArrayList<JdbcAliasRowSnapshot>();
                ArrayList<JdbcAliasRowSnapshot> deletedRows = new ArrayList<JdbcAliasRowSnapshot>();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)this.buildMessage("Executing version query [" + mapping.getVersionQuery() + "]"));
                }
                ps = connection.prepareStatement(mapping.getVersionQuery());
                if (this.getFetchSize() > 0) {
                    ps.setFetchSize(this.getFetchSize());
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    if (this.log.isDebugEnabled()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(this.buildMessage("Version row with values "));
                        ResultSetMetaData metaData = rs.getMetaData();
                        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                            sb.append("[").append(metaData.getColumnName(i)).append(":");
                            String value = rs.getString(i);
                            if (rs.wasNull()) {
                                value = "(null)";
                            }
                            sb.append(value);
                            sb.append("] ");
                        }
                        this.log.debug((Object)sb.toString());
                    }
                    JdbcAliasRowSnapshot newRowSnapshot = new JdbcAliasRowSnapshot();
                    ResultSetRowMarshallHelper marshallHelper = new ResultSetRowMarshallHelper(mapping, this.dialect, newRowSnapshot, this.compassGps.getMirrorCompass());
                    marshallHelper.marshallResultSet(rs);
                    JdbcAliasRowSnapshot oldRowSnapshot = oldAliasSnapshot.getRow(newRowSnapshot);
                    if (oldRowSnapshot == null) {
                        createdRows.add(newRowSnapshot);
                    } else if (oldRowSnapshot.isOlderThan(newRowSnapshot)) {
                        updatedRows.add(newRowSnapshot);
                    }
                    newAliasSnapshot.putRow(newRowSnapshot);
                }
                Iterator oldRowIt = oldAliasSnapshot.rowSnapshotIt();
                while (oldRowIt.hasNext()) {
                    JdbcAliasRowSnapshot tmpRow = (JdbcAliasRowSnapshot)oldRowIt.next();
                    if (newAliasSnapshot.getRow(tmpRow) != null) continue;
                    deletedRows.add(tmpRow);
                }
                if (!createdRows.isEmpty() || !updatedRows.isEmpty()) {
                    this.getSnapshotEventListener().onCreateAndUpdate(new CreateAndUpdateSnapshotEvent(connection, this.dialect, mapping, createdRows, updatedRows, this.compassGps));
                }
                if (!deletedRows.isEmpty()) {
                    this.getSnapshotEventListener().onDelete(new DeleteSnapshotEvent(connection, this.dialect, mapping, deletedRows, this.compassGps));
                }
                this.snapshot.putAliasSnapshot(newAliasSnapshot);
            }
        }
        catch (SQLException e) {
            throw new JdbcGpsDeviceException(this.buildMessage("Failed while mirroring data changes"), e);
        }
        finally {
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement(ps);
            JdbcUtils.closeConnection(connection);
        }
        if (this.isSaveSnapshotAfterMirror()) {
            this.getSnapshotPersister().save(this.snapshot);
        }
    }

    public void addMapping(ResultSetToResourceMapping mapping) {
        this.mappings.add(mapping);
    }

    public void setMappings(ResultSetToResourceMapping[] mappingsArr) {
        for (int i = 0; i < mappingsArr.length; ++i) {
            this.addMapping(mappingsArr[i]);
        }
    }

    public boolean isAutoDetectVersionColumnSqlType() {
        return this.autoDetectVersionColumnSqlType;
    }

    public void setAutoDetectVersionColumnSqlType(boolean autoDetectVersionColumnSqlType) {
        this.autoDetectVersionColumnSqlType = autoDetectVersionColumnSqlType;
    }
}

