/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassCallback;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.Resource;
import org.compass.gps.device.jdbc.JdbcGpsDeviceException;
import org.compass.gps.device.jdbc.JdbcUtils;
import org.compass.gps.device.jdbc.ResultSetRowMarshallHelper;
import org.compass.gps.device.jdbc.dialect.JdbcDialect;
import org.compass.gps.device.jdbc.mapping.IdColumnToPropertyMapping;
import org.compass.gps.device.jdbc.mapping.ResultSetToResourceMapping;
import org.compass.gps.device.jdbc.snapshot.ConfigureSnapshotEvent;
import org.compass.gps.device.jdbc.snapshot.CreateAndUpdateSnapshotEvent;
import org.compass.gps.device.jdbc.snapshot.DeleteSnapshotEvent;
import org.compass.gps.device.jdbc.snapshot.JdbcAliasRowSnapshot;
import org.compass.gps.device.jdbc.snapshot.JdbcSnapshotEventListener;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

public class ResultSetSnapshotEventListener
implements JdbcSnapshotEventListener {
    private static Log log = LogFactory.getLog((Class)ResultSetSnapshotEventListener.class);
    private HashMap createAndUpdateQueries;

    public void configure(ConfigureSnapshotEvent configureSnapshotEvent) throws JdbcGpsDeviceException {
        this.createAndUpdateQueries = new HashMap();
        Iterator it = configureSnapshotEvent.getMappings().iterator();
        while (it.hasNext()) {
            ResultSetToResourceMapping mapping = (ResultSetToResourceMapping)it.next();
            if (!mapping.supportsVersioning()) continue;
            StringBuffer sb = new StringBuffer();
            String selectQuery = mapping.getSelectQuery();
            sb.append(selectQuery);
            if (selectQuery.indexOf(" where") != -1) {
                sb.append(" and (");
            } else {
                sb.append(" where (");
            }
            boolean first = true;
            Iterator idIt = mapping.idMappingsIt();
            while (idIt.hasNext()) {
                IdColumnToPropertyMapping idMapping = (IdColumnToPropertyMapping)idIt.next();
                if (idMapping.getColumnNameForVersion() == null) {
                    throw new IllegalArgumentException("Id Mapping " + idMapping + " must have column name for versioning." + " If you set the column index, you must set the version as well");
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(" and ");
                }
                sb.append(idMapping.getColumnNameForVersion());
                sb.append(" = ?");
            }
            sb.append(")");
            String query = sb.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using create/update query [" + query + "] for alias [" + mapping.getAlias() + "]"));
            }
            this.createAndUpdateQueries.put(mapping.getAlias(), query);
        }
    }

    public void onDelete(final DeleteSnapshotEvent deleteSnapshotEvent) throws JdbcGpsDeviceException {
        final ResultSetToResourceMapping mapping = deleteSnapshotEvent.getMapping();
        CompassGpsInterfaceDevice compassGps = deleteSnapshotEvent.getCompassGps();
        compassGps.executeForMirror((CompassCallback)new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                Iterator it = deleteSnapshotEvent.getDeleteSnapshots().iterator();
                while (it.hasNext()) {
                    JdbcAliasRowSnapshot rowSnapshot = (JdbcAliasRowSnapshot)it.next();
                    List ids = rowSnapshot.getIds();
                    if (ids.size() == 1) {
                        session.delete(mapping.getAlias(), (Object)((String)ids.get(0)));
                        continue;
                    }
                    String[] idsArr = ids.toArray(new String[ids.size()]);
                    session.delete(mapping.getAlias(), (Object)idsArr);
                }
            }
        });
    }

    public void onCreateAndUpdate(CreateAndUpdateSnapshotEvent createAndUpdateSnapshotEvent) throws JdbcGpsDeviceException {
        this.doCreateAndUpdateFor(createAndUpdateSnapshotEvent.getCreateSnapshots(), createAndUpdateSnapshotEvent, true);
        this.doCreateAndUpdateFor(createAndUpdateSnapshotEvent.getUpdateSnapshots(), createAndUpdateSnapshotEvent, false);
    }

    private void doCreateAndUpdateFor(final List snapshots, final CreateAndUpdateSnapshotEvent createAndUpdateSnapshotEvent, final boolean useCreate) throws JdbcGpsDeviceException {
        final ResultSetToResourceMapping mapping = createAndUpdateSnapshotEvent.getMapping();
        final JdbcDialect dialect = createAndUpdateSnapshotEvent.getDialect();
        CompassGpsInterfaceDevice compassGps = createAndUpdateSnapshotEvent.getCompassGps();
        compassGps.executeForMirror((CompassCallback)new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                String query = (String)ResultSetSnapshotEventListener.this.createAndUpdateQueries.get(mapping.getAlias());
                PreparedStatement ps = null;
                try {
                    ps = createAndUpdateSnapshotEvent.getConnection().prepareStatement(query);
                    Iterator it = snapshots.iterator();
                    while (it.hasNext()) {
                        JdbcAliasRowSnapshot rowSnapshot = (JdbcAliasRowSnapshot)it.next();
                        Resource resource = session.createResource(mapping.getAlias());
                        ResultSetRowMarshallHelper marshallHelper = new ResultSetRowMarshallHelper(mapping, session, dialect, resource);
                        ps.clearParameters();
                        List ids = rowSnapshot.getIds();
                        for (int i = 0; i < ids.size(); ++i) {
                            String idValue = (String)ids.get(i);
                            dialect.setParameter(ps, i + 1, idValue);
                        }
                        ResultSet rs = ps.executeQuery();
                        if (!rs.next()) continue;
                        marshallHelper.marshallResultSet(rs);
                        if (useCreate) {
                            session.create((Object)resource);
                        } else {
                            session.save((Object)resource);
                        }
                        session.evictAll();
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new JdbcGpsDeviceException("Failed to execute query for create/update", e);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeStatement(ps);
                        throw throwable;
                    }
                }
                JdbcUtils.closeStatement(ps);
            }
        });
    }
}

