/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdo;

import javax.jdo.PersistenceManagerFactory;
import javax.jdo.listener.DeleteLifecycleListener;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.listener.StoreLifecycleListener;
import org.compass.core.CompassCallback;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.mapping.CascadeMapping;
import org.compass.gps.CompassGpsException;
import org.compass.gps.PassiveMirrorGpsDevice;
import org.compass.gps.device.jdo.JdoGpsDevice;
import org.compass.gps.device.jdo.JdoGpsDeviceException;

public class Jdo2GpsDevice
extends JdoGpsDevice
implements PassiveMirrorGpsDevice {
    private boolean mirrorDataChanges = true;
    private boolean ignoreMirrorExceptions;
    private JdoGpsInstanceLifecycleListener instanceLifecycleListener;

    public Jdo2GpsDevice() {
    }

    public Jdo2GpsDevice(String name, PersistenceManagerFactory persistenceManagerFactory) {
        super(name, persistenceManagerFactory);
    }

    public boolean isMirrorDataChanges() {
        return this.mirrorDataChanges;
    }

    public void setMirrorDataChanges(boolean mirrorDataChanges) {
        this.mirrorDataChanges = mirrorDataChanges;
    }

    public boolean isIgnoreMirrorExceptions() {
        return this.ignoreMirrorExceptions;
    }

    public void setIgnoreMirrorExceptions(boolean ignoreMirrorExceptions) {
        this.ignoreMirrorExceptions = ignoreMirrorExceptions;
    }

    protected void doStart() throws CompassGpsException {
        super.doStart();
        if (this.isMirrorDataChanges()) {
            this.instanceLifecycleListener = new JdoGpsInstanceLifecycleListener();
            this.persistenceManagerFactory.addInstanceLifecycleListener((InstanceLifecycleListener)this.instanceLifecycleListener, null);
        }
    }

    protected void doStop() throws CompassGpsException {
        if (this.isMirrorDataChanges()) {
            this.persistenceManagerFactory.removeInstanceLifecycleListener((InstanceLifecycleListener)this.instanceLifecycleListener);
        }
    }

    private class JdoGpsInstanceLifecycleListener
    implements DeleteLifecycleListener,
    StoreLifecycleListener {
        public void preDelete(InstanceLifecycleEvent event) {
        }

        public void preStore(InstanceLifecycleEvent event) {
        }

        public void postDelete(InstanceLifecycleEvent event) {
            if (!Jdo2GpsDevice.this.shouldMirrorDataChanges() || Jdo2GpsDevice.this.isPerformingIndexOperation()) {
                return;
            }
            final Object entity = event.getSource();
            if (!Jdo2GpsDevice.this.compassGps.hasMappingForEntityForMirror(entity.getClass(), CascadeMapping.Cascade.DELETE)) {
                return;
            }
            try {
                if (Jdo2GpsDevice.this.log.isDebugEnabled()) {
                    Jdo2GpsDevice.this.log.debug((Object)Jdo2GpsDevice.this.buildMessage("Deleting [" + entity + "]"));
                }
                Jdo2GpsDevice.this.compassGps.executeForMirror((CompassCallback)new CompassCallbackWithoutResult(){

                    protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                        session.delete(entity);
                    }
                });
            }
            catch (Exception e) {
                if (Jdo2GpsDevice.this.isIgnoreMirrorExceptions()) {
                    Jdo2GpsDevice.this.log.error((Object)Jdo2GpsDevice.this.buildMessage("Failed while deleting [" + entity + "]"), (Throwable)e);
                }
                throw new JdoGpsDeviceException(Jdo2GpsDevice.this.buildMessage("Failed while deleting [" + entity + "]"), e);
            }
        }

        public void postStore(InstanceLifecycleEvent event) {
            if (!Jdo2GpsDevice.this.shouldMirrorDataChanges() || Jdo2GpsDevice.this.isPerformingIndexOperation()) {
                return;
            }
            final Object entity = event.getSource();
            if (!Jdo2GpsDevice.this.compassGps.hasMappingForEntityForMirror(entity.getClass(), CascadeMapping.Cascade.SAVE)) {
                return;
            }
            try {
                if (Jdo2GpsDevice.this.log.isDebugEnabled()) {
                    Jdo2GpsDevice.this.log.debug((Object)Jdo2GpsDevice.this.buildMessage("Updating [" + entity + "]"));
                }
                Jdo2GpsDevice.this.compassGps.executeForMirror((CompassCallback)new CompassCallbackWithoutResult(){

                    protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                        session.save(entity);
                    }
                });
            }
            catch (Exception e) {
                if (Jdo2GpsDevice.this.isIgnoreMirrorExceptions()) {
                    Jdo2GpsDevice.this.log.error((Object)Jdo2GpsDevice.this.buildMessage("Failed while updating [" + entity + "]"), (Throwable)e);
                }
                throw new JdoGpsDeviceException(Jdo2GpsDevice.this.buildMessage("Failed while updating [" + entity + "]"), e);
            }
        }
    }
}

