/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.compass.core.CompassSession;
import org.compass.core.util.Assert;
import org.compass.gps.CompassGpsException;
import org.compass.gps.PassiveMirrorGpsDevice;
import org.compass.gps.device.jpa.DefaultEntityManagerWrapper;
import org.compass.gps.device.jpa.DefaultJpaQueryProvider;
import org.compass.gps.device.jpa.EntityManagerWrapper;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.JpaQueryProvider;
import org.compass.gps.device.jpa.NativeEntityManagerFactoryExtractor;
import org.compass.gps.device.jpa.entities.EntityInformation;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocator;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocatorDetector;
import org.compass.gps.device.jpa.lifecycle.JpaEntityLifecycleInjector;
import org.compass.gps.device.jpa.lifecycle.JpaEntityLifecycleInjectorDetector;
import org.compass.gps.device.jpa.support.NativeJpaHelper;
import org.compass.gps.device.support.parallel.AbstractParallelGpsDevice;
import org.compass.gps.device.support.parallel.IndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaGpsDevice
extends AbstractParallelGpsDevice
implements PassiveMirrorGpsDevice {
    private boolean mirrorDataChanges = true;
    private int fetchCount = 200;
    private EntityManagerFactory entityManagerFactory;
    private EntityManagerWrapper entityManagerWrapper;
    private JpaEntityLifecycleInjector lifecycleInjector;
    private boolean injectEntityLifecycleListener;
    private NativeEntityManagerFactoryExtractor nativeEntityManagerFactoryExtractor;
    private EntityManagerFactory nativeEntityManagerFactory;
    private JpaEntitiesLocator entitiesLocator;
    private Map<Class<?>, JpaQueryProvider> queryProviderByClass = new HashMap();
    private Map<String, JpaQueryProvider> queryProviderByName = new HashMap<String, JpaQueryProvider>();

    public JpaGpsDevice() {
    }

    public JpaGpsDevice(String name, EntityManagerFactory entityManagerFactory) {
        this.setName(name);
        this.setEntityManagerFactory(entityManagerFactory);
    }

    @Override
    protected void doStart() throws CompassGpsException {
        Assert.notNull((Object)this.entityManagerFactory, (String)this.buildMessage("Must set JPA EntityManagerFactory"));
        if (this.entityManagerWrapper == null) {
            this.entityManagerWrapper = new DefaultEntityManagerWrapper();
        }
        this.entityManagerWrapper.setUp(this.entityManagerFactory);
        this.nativeEntityManagerFactory = this.entityManagerFactory;
        if (this.nativeEntityManagerFactoryExtractor != null) {
            this.nativeEntityManagerFactory = this.nativeEntityManagerFactoryExtractor.extractNative(this.nativeEntityManagerFactory);
            if (this.nativeEntityManagerFactory == null) {
                throw new JpaGpsDeviceException(this.buildMessage("Native EntityManager extractor returned null"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.buildMessage("Using native EntityManagerFactory [" + this.nativeEntityManagerFactory.getClass().getName() + "] extracted by [" + this.nativeEntityManagerFactoryExtractor.getClass().getName() + "]"));
            }
        } else {
            this.nativeEntityManagerFactory = NativeJpaHelper.extractNativeJpa(this.entityManagerFactory);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.buildMessage("Using native EntityManagerFactory [" + this.nativeEntityManagerFactory.getClass().getName() + "] using default extractor"));
            }
        }
        if (this.entitiesLocator == null) {
            this.entitiesLocator = JpaEntitiesLocatorDetector.detectLocator(this.nativeEntityManagerFactory);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.buildMessage("Using index entityLocator [" + this.entitiesLocator.getClass().getName() + "]"));
            }
        }
        if (this.injectEntityLifecycleListener && this.mirrorDataChanges) {
            if (this.lifecycleInjector == null) {
                this.lifecycleInjector = JpaEntityLifecycleInjectorDetector.detectInjector(this.nativeEntityManagerFactory);
            }
            if (this.lifecycleInjector == null) {
                throw new JpaGpsDeviceException(this.buildMessage("Failed to locate lifecycleInjector"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.buildMessage("Using lifecycleInjector [" + this.lifecycleInjector.getClass().getName() + "]"));
            }
            this.lifecycleInjector.injectLifecycle(this.nativeEntityManagerFactory, this);
        }
    }

    @Override
    protected void doStop() throws CompassGpsException {
        if (this.injectEntityLifecycleListener && this.mirrorDataChanges) {
            this.lifecycleInjector.removeLifecycle(this.nativeEntityManagerFactory, this);
        }
    }

    @Override
    protected IndexEntity[] doGetIndexEntities() throws CompassGpsException {
        IndexEntity[] entitiesInformation;
        for (IndexEntity entityInformation : entitiesInformation = this.entitiesLocator.locate(this.nativeEntityManagerFactory, this)) {
            if (this.queryProviderByClass.get(((EntityInformation)entityInformation).getEntityClass()) != null) {
                ((EntityInformation)entityInformation).setQueryProvider(this.queryProviderByClass.get(((EntityInformation)entityInformation).getEntityClass()));
            }
            if (this.queryProviderByName.get(((EntityInformation)entityInformation).getName()) == null) continue;
            ((EntityInformation)entityInformation).setQueryProvider(this.queryProviderByName.get(((EntityInformation)entityInformation).getName()));
        }
        return entitiesInformation;
    }

    @Override
    protected IndexEntitiesIndexer doGetIndexEntitiesIndexer() {
        return new JpaIndexEntitiesIndexer();
    }

    @Override
    public boolean isMirrorDataChanges() {
        return this.mirrorDataChanges;
    }

    @Override
    public void setMirrorDataChanges(boolean mirrorDataChanges) {
        this.mirrorDataChanges = mirrorDataChanges;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setEntityManagerWrapper(EntityManagerWrapper entityManagerWrapper) {
        this.entityManagerWrapper = entityManagerWrapper;
    }

    public void setNativeEntityManagerFactoryExtractor(NativeEntityManagerFactoryExtractor nativeEntityManagerFactoryExtractor) {
        this.nativeEntityManagerFactoryExtractor = nativeEntityManagerFactoryExtractor;
    }

    public void setInjectEntityLifecycleListener(boolean injectEntityLifecycleListener) {
        this.injectEntityLifecycleListener = injectEntityLifecycleListener;
    }

    public void setLifecycleInjector(JpaEntityLifecycleInjector lifecycleInjector) {
        this.lifecycleInjector = lifecycleInjector;
    }

    public void setEntitiesLocator(JpaEntitiesLocator entitiesLocator) {
        this.entitiesLocator = entitiesLocator;
    }

    public void setFetchCount(int fetchCount) {
        this.fetchCount = fetchCount;
    }

    public void setIndexSelectQuery(Class<?> entityClass, String selectQuery) {
        this.setIndexQueryProvider(entityClass, (JpaQueryProvider)new DefaultJpaQueryProvider(selectQuery));
    }

    public void setIndexSelectQuery(String entityName, String selectQuery) {
        this.setIndexQueryProvider(entityName, (JpaQueryProvider)new DefaultJpaQueryProvider(selectQuery));
    }

    public void setIndexQueryProvider(Class<?> entityClass, JpaQueryProvider queryProvider) {
        this.queryProviderByClass.put(entityClass, queryProvider);
    }

    public void setIndexQueryProvider(String entityName, JpaQueryProvider queryProvider) {
        this.queryProviderByName.put(entityName, queryProvider);
    }

    private class JpaIndexEntitiesIndexer
    implements IndexEntitiesIndexer {
        private JpaIndexEntitiesIndexer() {
        }

        public void performIndex(CompassSession session, IndexEntity[] entities) {
            for (IndexEntity indexEntity : entities) {
                EntityInformation entityInformation = (EntityInformation)indexEntity;
                if (JpaGpsDevice.this.isFilteredForIndex(entityInformation.getName())) continue;
                EntityManagerWrapper wrapper = JpaGpsDevice.this.entityManagerWrapper.newInstance();
                try {
                    int current = 0;
                    wrapper.open();
                    EntityManager entityManager = wrapper.getEntityManager();
                    while (true) {
                        if (JpaGpsDevice.this.log.isDebugEnabled()) {
                            JpaGpsDevice.this.log.debug((Object)JpaGpsDevice.this.buildMessage("Indexing entities [" + entityInformation.getName() + "] range [" + current + "-" + (current + JpaGpsDevice.this.fetchCount) + "] using query [" + entityInformation.getQueryProvider() + "]"));
                        }
                        Query query = entityInformation.getQueryProvider().createQuery(entityManager, entityInformation);
                        query.setFirstResult(current);
                        query.setMaxResults(JpaGpsDevice.this.fetchCount);
                        List results = query.getResultList();
                        for (Object result : results) {
                            session.create(result);
                        }
                        session.evictAll();
                        entityManager.clear();
                        if (results.size() < JpaGpsDevice.this.fetchCount) break;
                        current += JpaGpsDevice.this.fetchCount;
                    }
                    wrapper.close();
                }
                catch (Exception e) {
                    JpaGpsDevice.this.log.error((Object)JpaGpsDevice.this.buildMessage("Failed to index the database"), (Throwable)e);
                    wrapper.closeOnError();
                    if (!(e instanceof JpaGpsDeviceException)) {
                        throw new JpaGpsDeviceException(JpaGpsDevice.this.buildMessage("Failed to index the database"), e);
                    }
                    throw (JpaGpsDeviceException)((Object)e);
                }
            }
        }
    }
}

