/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.entities;

import java.util.ArrayList;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.mapping.ResourceMapping;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.entities.EntityInformation;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocator;
import org.compass.gps.spi.CompassGpsInterfaceDevice;
import org.hibernate.EntityMode;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.metadata.ClassMetadata;

public class HibernateJpaEntitiesLocator
implements JpaEntitiesLocator {
    protected Log log = LogFactory.getLog(this.getClass());

    public EntityInformation[] locate(EntityManagerFactory entityManagerFactory, JpaGpsDevice device) throws JpaGpsDeviceException {
        CompassGpsInterfaceDevice gps = (CompassGpsInterfaceDevice)device.getGps();
        HibernateEntityManagerFactory hibernateEntityManagerFactory = (HibernateEntityManagerFactory)entityManagerFactory;
        SessionFactory sessionFactory = hibernateEntityManagerFactory.getSessionFactory();
        ArrayList<EntityInformation> entitiesList = new ArrayList<EntityInformation>();
        Map allClassMetaData = sessionFactory.getAllClassMetadata();
        for (Object o : allClassMetaData.keySet()) {
            String entityname = (String)o;
            if (!gps.hasMappingForEntityForIndex(entityname)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Entity [" + entityname + "] does not have compass mapping, filtering it out"));
                continue;
            }
            ClassMetadata classMetadata = (ClassMetadata)allClassMetaData.get(entityname);
            if (this.shouldFilter(entityname, classMetadata, device)) continue;
            Class clazz = classMetadata.getMappedClass(EntityMode.POJO);
            ResourceMapping resourceMapping = gps.getMappingForEntityForIndex(entityname);
            EntityInformation entityInformation = new EntityInformation(clazz, entityname, resourceMapping.getSubIndexHash().getSubIndexes());
            entitiesList.add(entityInformation);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Entity [" + entityname + "] will be indexed"));
        }
        return entitiesList.toArray(new EntityInformation[entitiesList.size()]);
    }

    protected boolean shouldFilter(String entityname, ClassMetadata classMetadata, JpaGpsDevice device) {
        Class superClass;
        Class clazz = classMetadata.getMappedClass(EntityMode.POJO);
        if (classMetadata.isInherited() && (superClass = clazz.getSuperclass()) != null && ((CompassGpsInterfaceDevice)device.getGps()).hasMappingForEntityForIndex(superClass)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Entity [" + entityname + "] is inherited and super class [" + superClass + "] has compass mapping, filtering it out"));
            }
            return true;
        }
        return false;
    }
}

