/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.entities;

import java.util.ArrayList;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.compass.core.mapping.ResourceMapping;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.entities.EntityInformation;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocator;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

public class OpenJPAJpaEntitiesLocator
implements JpaEntitiesLocator {
    protected Log log = LogFactory.getLog(this.getClass());

    public EntityInformation[] locate(EntityManagerFactory entityManagerFactory, JpaGpsDevice device) throws JpaGpsDeviceException {
        ClassMetaData[] classMetaDatas;
        CompassGpsInterfaceDevice gps = (CompassGpsInterfaceDevice)device.getGps();
        OpenJPAEntityManagerFactory emf = OpenJPAPersistence.cast((EntityManagerFactory)entityManagerFactory);
        ArrayList<EntityInformation> entitiesList = new ArrayList<EntityInformation>();
        OpenJPAEntityManager entityManager = emf.createEntityManager();
        entityManager.close();
        for (ClassMetaData classMetaData : classMetaDatas = emf.getConfiguration().getMetaDataRepositoryInstance().getMetaDatas()) {
            String entityname = classMetaData.getDescribedType().getName();
            if (!gps.hasMappingForEntityForIndex(entityname)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Entity [" + entityname + "] does not have compass mapping, filtering it out"));
                continue;
            }
            if (this.shouldFilter(entityname, classMetaData, device)) continue;
            Class clazz = classMetaData.getDescribedType();
            ResourceMapping resourceMapping = gps.getMappingForEntityForIndex(entityname);
            EntityInformation entityInformation = new EntityInformation(clazz, entityname, resourceMapping.getSubIndexHash().getSubIndexes());
            entitiesList.add(entityInformation);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Entity [" + entityname + "] will be indexed"));
        }
        return entitiesList.toArray(new EntityInformation[entitiesList.size()]);
    }

    protected boolean shouldFilter(String entityname, ClassMetaData classMetadata, JpaGpsDevice device) {
        Class superClass;
        Class clazz = classMetadata.getDescribedType();
        if (classMetadata.getMappedPCSuperclassMetaData() != null && (superClass = clazz.getSuperclass()) != null && ((CompassGpsInterfaceDevice)device.getGps()).hasMappingForEntityForIndex(superClass)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Entity [" + entityname + "] is inherited and super class [" + superClass + "] has compass mapping, filtering it out"));
            }
            return true;
        }
        return false;
    }
}

