/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.support.parallel;

import org.compass.core.CompassSession;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.AbstractGpsDevice;
import org.compass.gps.device.support.parallel.ConcurrentParallelIndexExecutor;
import org.compass.gps.device.support.parallel.IndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntitiesPartitioner;
import org.compass.gps.device.support.parallel.IndexEntity;
import org.compass.gps.device.support.parallel.ParallelIndexExecutor;
import org.compass.gps.device.support.parallel.SubIndexIndexEntitiesPartitioner;

public abstract class AbstractParallelGpsDevice
extends AbstractGpsDevice {
    private ParallelIndexExecutor parallelIndexExecutor = new ConcurrentParallelIndexExecutor();
    private IndexEntitiesPartitioner indexEntitiesPartitioner = new SubIndexIndexEntitiesPartitioner();
    private IndexEntity[][] entities;
    private IndexEntitiesIndexer indexEntitiesIndexer;

    public synchronized void start() throws CompassGpsException {
        super.start();
        this.entities = this.indexEntitiesPartitioner.partition(this.doGetIndexEntities());
        this.indexEntitiesIndexer = this.doGetIndexEntitiesIndexer();
    }

    public synchronized void index() throws CompassGpsException {
        if (!this.isRunning()) {
            throw new IllegalStateException(this.buildMessage("must be running in order to perform the index operation"));
        }
        this.parallelIndexExecutor.performIndex(this.entities, this.indexEntitiesIndexer, this.compassGps);
    }

    protected abstract IndexEntity[] doGetIndexEntities() throws CompassGpsException;

    protected abstract IndexEntitiesIndexer doGetIndexEntitiesIndexer();

    protected final void doIndex(CompassSession session) throws CompassGpsException {
        throw new IllegalStateException("This should not be called");
    }

    public void setParallelIndexExecutor(ParallelIndexExecutor parallelIndexExecutor) {
        this.parallelIndexExecutor = parallelIndexExecutor;
    }

    public void setIndexEntitiesPartitioner(IndexEntitiesPartitioner indexEntitiesPartitioner) {
        this.indexEntitiesPartitioner = indexEntitiesPartitioner;
    }
}

