/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.support.parallel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.compass.core.CompassCallback;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.util.backport.java.util.concurrent.Callable;
import org.compass.core.util.backport.java.util.concurrent.ExecutionException;
import org.compass.core.util.backport.java.util.concurrent.ExecutorService;
import org.compass.core.util.backport.java.util.concurrent.Executors;
import org.compass.core.util.backport.java.util.concurrent.Future;
import org.compass.core.util.backport.java.util.concurrent.ThreadFactory;
import org.compass.core.util.concurrent.SingleThreadThreadFactory;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.support.parallel.IndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntity;
import org.compass.gps.device.support.parallel.ParallelIndexExecutor;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

public class ConcurrentParallelIndexExecutor
implements ParallelIndexExecutor {
    private int maxThreads = -1;

    public ConcurrentParallelIndexExecutor() {
    }

    public ConcurrentParallelIndexExecutor(int maxThreads) {
        if (maxThreads < -1 || maxThreads == 0) {
            throw new IllegalArgumentException("maxThreads must either be -1 or a value greater than 0");
        }
        this.maxThreads = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performIndex(IndexEntity[][] entities, final IndexEntitiesIndexer indexEntitiesIndexer, final CompassGpsInterfaceDevice compassGps) {
        int maxThreads = this.maxThreads;
        if (maxThreads == -1) {
            maxThreads = entities.length;
        }
        ExecutorService executorService = Executors.newFixedThreadPool((int)maxThreads, (ThreadFactory)new SingleThreadThreadFactory("Compass Gps Index", false));
        try {
            List futures;
            ArrayList<1> tasks = new ArrayList<1>();
            for (int i = 0; i < entities.length; ++i) {
                final IndexEntity[] indexEntities = entities[i];
                tasks.add(new Callable(){

                    public Object call() throws Exception {
                        compassGps.executeForIndex((CompassCallback)new CompassCallbackWithoutResult(){

                            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                                indexEntitiesIndexer.performIndex(session, indexEntities);
                                ((InternalCompassSession)session).flush();
                            }
                        });
                        return null;
                    }
                });
            }
            try {
                futures = executorService.invokeAll(tasks);
            }
            catch (InterruptedException e) {
                throw new CompassGpsException("Failed to index, interrupted", e);
            }
            Iterator it = futures.iterator();
            while (it.hasNext()) {
                Future future = (Future)it.next();
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw new CompassGpsException("Failed to index, interrupted", e);
                }
                catch (ExecutionException e) {
                    throw new CompassGpsException("Failed to index, erxecution exception", e);
                    return;
                }
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }
}

