/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.impl;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.spi.InternalCompass;
import org.compass.core.util.ClassUtils;
import org.compass.gps.CompassGpsDevice;
import org.compass.gps.CompassGpsException;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

public abstract class AbstractCompassGps
implements CompassGpsInterfaceDevice {
    protected Log log = LogFactory.getLog(this.getClass());
    protected HashMap devices = new HashMap();
    private boolean started = false;
    private boolean performingIndexOperation = false;

    public void addGpsDevice(CompassGpsDevice gpsDevice) {
        this.checkDeviceValidity(gpsDevice);
        gpsDevice.setGps(this);
        this.devices.put(gpsDevice.getName(), gpsDevice);
    }

    public void setGpsDevices(CompassGpsDevice[] devices) {
        this.devices.clear();
        for (int i = 0; i < devices.length; ++i) {
            this.checkDeviceValidity(devices[i]);
            devices[i].setGps(this);
            this.devices.put(devices[i].getName(), devices[i]);
        }
    }

    private void checkDeviceValidity(CompassGpsDevice device) {
        if (device.getName() == null) {
            throw new IllegalArgumentException("Must specify a name for a gps device");
        }
        if (this.devices.get(device.getName()) != null) {
            throw new IllegalArgumentException("A gps device with the name [" + device.getName() + "] is defined twice. It is not allowed.");
        }
    }

    protected boolean hasRootMappingForEntity(Class clazz, Compass checkedCompass) {
        return this.getRootMappingForEntity(clazz, checkedCompass) != null;
    }

    protected boolean hasMappingForEntity(Class clazz, Compass checkedCompass, CascadeMapping.Cascade cascade) {
        ResourceMapping resourceMapping = ((InternalCompass)checkedCompass).getMapping().getResourceMappingByClass(clazz);
        if (resourceMapping == null) {
            return false;
        }
        if (resourceMapping.isRoot()) {
            return true;
        }
        return resourceMapping.operationAllowed(cascade);
    }

    protected boolean hasMappingForEntity(String name, Compass checkedCompass, CascadeMapping.Cascade cascade) {
        ResourceMapping resourceMapping = ((InternalCompass)checkedCompass).getMapping().getResourceMappingByAlias(name);
        if (resourceMapping == null) {
            return false;
        }
        if (resourceMapping.isRoot()) {
            return true;
        }
        return resourceMapping.operationAllowed(cascade);
    }

    protected ResourceMapping getRootMappingForEntity(Class clazz, Compass checkedCompass) {
        return ((InternalCompass)checkedCompass).getMapping().getRootMappingByClass(clazz);
    }

    protected boolean hasRootMappingForEntity(String name, Compass checkedCompass) {
        return this.getRootMappingForEntity(name, checkedCompass) != null;
    }

    protected ResourceMapping getMappingForEntity(String name, Compass checkedCompass) {
        ResourceMapping resourceMapping = ((InternalCompass)checkedCompass).getMapping().getResourceMappingByAlias(name);
        if (resourceMapping != null) {
            return resourceMapping;
        }
        try {
            Class clazz = ClassUtils.forName((String)name);
            return ((InternalCompass)checkedCompass).getMapping().getResourceMappingByClass(clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected ResourceMapping getRootMappingForEntity(String name, Compass checkedCompass) {
        ResourceMapping resourceMapping = ((InternalCompass)checkedCompass).getMapping().getRootMappingByAlias(name);
        if (resourceMapping != null) {
            return resourceMapping;
        }
        try {
            Class clazz = ClassUtils.forName((String)name);
            return ((InternalCompass)checkedCompass).getMapping().getRootMappingByClass(clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void index() throws CompassGpsException, IllegalStateException {
        if (!this.isRunning()) {
            throw new IllegalStateException("CompassGps must be running in order to perform the index operation");
        }
        if (((InternalCompass)this.getMirrorCompass()).getTransactionFactory().getTransactionBoundSession() != null) {
            throw new CompassGpsException("index() operation is not allowed to be called within a transaction (mirror)");
        }
        if (((InternalCompass)this.getIndexCompass()).getTransactionFactory().getTransactionBoundSession() != null) {
            throw new CompassGpsException("index() operation is not allowed to be called within a transaction (index)");
        }
        if (this.isPerformingIndexOperation()) {
            throw new IllegalArgumentException("Indexing alredy in process, not allowed to call index()");
        }
        try {
            this.performingIndexOperation = true;
            this.doIndex();
        }
        finally {
            this.performingIndexOperation = false;
        }
    }

    protected abstract void doIndex() throws CompassGpsException;

    public synchronized void start() throws CompassGpsException {
        this.doStart();
        if (!this.started) {
            Iterator it = this.devices.values().iterator();
            while (it.hasNext()) {
                CompassGpsDevice device = (CompassGpsDevice)it.next();
                device.start();
            }
            this.started = true;
        }
    }

    protected abstract void doStart() throws CompassGpsException;

    protected abstract void doStop() throws CompassGpsException;

    public synchronized void stop() throws CompassGpsException {
        if (this.started) {
            Iterator it = this.devices.values().iterator();
            while (it.hasNext()) {
                CompassGpsDevice device = (CompassGpsDevice)it.next();
                device.stop();
            }
            this.started = false;
        }
        this.doStop();
    }

    public boolean isRunning() {
        return this.started;
    }

    public boolean isPerformingIndexOperation() {
        return this.performingIndexOperation;
    }
}

