/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.impl;

import java.util.Iterator;
import org.compass.core.Compass;
import org.compass.core.CompassCallback;
import org.compass.core.CompassException;
import org.compass.core.CompassTemplate;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineIndexManager;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.gps.CompassGpsDevice;
import org.compass.gps.CompassGpsException;
import org.compass.gps.impl.AbstractCompassGps;

public class DualCompassGps
extends AbstractCompassGps {
    private Compass indexCompass;
    private CompassTemplate indexCompassTemplate;
    private Compass mirrorCompass;
    private CompassTemplate mirrorCompassTemplate;

    public DualCompassGps() {
    }

    public DualCompassGps(Compass indexCompass, Compass mirrorCompass) {
        this.indexCompass = indexCompass;
        this.mirrorCompass = mirrorCompass;
    }

    protected void doStart() throws CompassGpsException {
        if (this.indexCompass == null) {
            throw new IllegalArgumentException("Must set the indexCompass property (for batch indexing)");
        }
        this.indexCompassTemplate = new CompassTemplate(this.indexCompass);
        if (this.mirrorCompass != null) {
            this.mirrorCompassTemplate = new CompassTemplate(this.mirrorCompass);
        }
    }

    protected void doStop() throws CompassGpsException {
    }

    protected void doIndex() throws CompassGpsException {
        boolean stoppedMirrorCompassOptimizer = false;
        boolean stoppedIndexCompassOptimizer = false;
        boolean stoppedIndexCompassIndexManager = false;
        if (this.mirrorCompass != null && this.mirrorCompass.getSearchEngineOptimizer().isRunning()) {
            this.mirrorCompass.getSearchEngineOptimizer().stop();
            stoppedMirrorCompassOptimizer = true;
        }
        if (this.indexCompass.getSearchEngineOptimizer().isRunning()) {
            this.indexCompass.getSearchEngineOptimizer().stop();
            stoppedIndexCompassOptimizer = true;
        }
        if (this.indexCompass.getSearchEngineIndexManager().isRunning()) {
            this.indexCompass.getSearchEngineIndexManager().stop();
            stoppedIndexCompassIndexManager = true;
        }
        this.indexCompass.getSearchEngineIndexManager().clearCache();
        this.indexCompass.getSearchEngineIndexManager().deleteIndex();
        this.indexCompass.getSearchEngineIndexManager().createIndex();
        this.mirrorCompass.getSearchEngineIndexManager().replaceIndex(this.indexCompass.getSearchEngineIndexManager(), new SearchEngineIndexManager.ReplaceIndexCallback(){

            public void buildIndexIfNeeded() throws SearchEngineException {
                Iterator it = DualCompassGps.this.devices.values().iterator();
                while (it.hasNext()) {
                    CompassGpsDevice device = (CompassGpsDevice)it.next();
                    device.index();
                }
            }
        });
        if (stoppedMirrorCompassOptimizer) {
            this.mirrorCompass.getSearchEngineOptimizer().start();
        }
        if (stoppedIndexCompassOptimizer) {
            this.indexCompass.getSearchEngineOptimizer().start();
        }
        if (stoppedIndexCompassIndexManager) {
            this.indexCompass.getSearchEngineIndexManager().start();
        }
    }

    public void executeForIndex(CompassCallback callback) throws CompassException {
        this.indexCompassTemplate.execute(callback);
    }

    public void executeForMirror(CompassCallback callback) throws CompassException {
        this.mirrorCompassTemplate.execute(callback);
    }

    public boolean hasMappingForEntityForIndex(Class clazz) throws CompassException {
        return this.hasRootMappingForEntity(clazz, this.indexCompass);
    }

    public boolean hasMappingForEntityForIndex(String name) throws CompassException {
        return this.hasRootMappingForEntity(name, this.indexCompass);
    }

    public boolean hasMappingForEntityForMirror(Class clazz, CascadeMapping.Cascade cascade) throws CompassException {
        return this.hasMappingForEntity(clazz, this.mirrorCompass, cascade);
    }

    public boolean hasMappingForEntityForMirror(String name, CascadeMapping.Cascade cascade) throws CompassException {
        return this.hasMappingForEntity(name, this.mirrorCompass, cascade);
    }

    public ResourceMapping getMappingForEntityForIndex(String name) throws CompassException {
        return this.getRootMappingForEntity(name, this.indexCompass);
    }

    public ResourceMapping getMappingForEntityForIndex(Class clazz) throws CompassException {
        return this.getRootMappingForEntity(clazz, this.indexCompass);
    }

    public Compass getIndexCompass() {
        return this.indexCompass;
    }

    public void setIndexCompass(Compass indexCompass) {
        this.indexCompass = indexCompass;
    }

    public Compass getMirrorCompass() {
        return this.mirrorCompass;
    }

    public void setMirrorCompass(Compass mirrorCompass) {
        this.mirrorCompass = mirrorCompass;
    }

    public CompassTemplate getIndexCompassTemplate() {
        return this.indexCompassTemplate;
    }

    public CompassTemplate getMirrorCompassTemplate() {
        return this.mirrorCompassTemplate;
    }
}

