/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.ValidationHelper;
import com.opensymphony.workflow.loader.XMLUtil;
import com.opensymphony.workflow.util.Validatable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class RestrictionDescriptor
extends AbstractDescriptor
implements Validatable {
    protected List conditions = new ArrayList();

    public RestrictionDescriptor() {
    }

    public RestrictionDescriptor(Element restriction) {
        this.init(restriction);
    }

    public List getConditions() {
        return this.conditions;
    }

    public void validate() throws InvalidWorkflowDescriptorException {
        ValidationHelper.validate(this.conditions);
    }

    public void writeXML(PrintWriter out, int indent) {
        if (this.conditions.size() == 0) {
            return;
        }
        XMLUtil.printIndent(out, indent++);
        out.println("<restrict-to>");
        if (this.conditions.size() > 0) {
            for (int i = 0; i < this.conditions.size(); ++i) {
                ConditionsDescriptor condition = (ConditionsDescriptor)this.conditions.get(i);
                condition.writeXML(out, indent);
            }
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</restrict-to>");
    }

    protected void init(Element restriction) {
        List conditionNodes = XMLUtil.getChildElements(restriction, "conditions");
        int length = conditionNodes.size();
        for (int i = 0; i < length; ++i) {
            Element condition = (Element)conditionNodes.get(i);
            ConditionsDescriptor conditionDescriptor = new ConditionsDescriptor(condition);
            conditionDescriptor.setParent(this);
            this.conditions.add(conditionDescriptor);
        }
    }
}

