/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.configuration;

import java.util.Iterator;
import java.util.Map;
import org.nnsoft.guice.rocoto.configuration.KeyValue;

final class PropertiesIterator<K, V>
implements Iterator<Map.Entry<String, String>> {
    private final String keyPrefix;
    private final Iterator<Map.Entry<K, V>> propertiesIterator;

    public static final <K, V> PropertiesIterator<K, V> newPropertiesIterator(Map<K, V> properties) {
        return new PropertiesIterator<K, V>(null, properties);
    }

    public static final <K, V> PropertiesIterator<K, V> newPropertiesIterator(String keyPrefix, Map<K, V> properties) {
        return new PropertiesIterator<K, V>(keyPrefix, properties);
    }

    private PropertiesIterator(String keyPrefix, Map<K, V> properties) {
        this.keyPrefix = keyPrefix;
        this.propertiesIterator = properties.entrySet().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.propertiesIterator.hasNext();
    }

    @Override
    public Map.Entry<String, String> next() {
        Map.Entry<K, V> next = this.propertiesIterator.next();
        String key = String.valueOf(next.getKey());
        if (this.keyPrefix != null && this.keyPrefix.length() > 0) {
            key = this.keyPrefix + key;
        }
        return new KeyValue(key, String.valueOf(next.getValue()));
    }

    @Override
    public void remove() {
    }
}

