/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.variables;

import java.util.ArrayList;
import org.nnsoft.guice.rocoto.variables.Appender;
import org.nnsoft.guice.rocoto.variables.KeyAppender;
import org.nnsoft.guice.rocoto.variables.MixinAppender;
import org.nnsoft.guice.rocoto.variables.Parser;
import org.nnsoft.guice.rocoto.variables.TextAppender;

public class AntStyleParser
implements Parser {
    static final String VAR_START = "${";
    static final int VAR_START_LEN = "${".length();
    static final char VAR_CLOSE = '}';
    static final int VAR_CLOSE_LEN = 1;
    static final char PIPE_SEPARATOR = '|';
    static final int PIPE_SEPARATOR_LEN = 1;

    @Override
    public Appender parse(String pattern) {
        ArrayList<Appender> appenders = new ArrayList<Appender>();
        int prev = 0;
        int pos = 0;
        while ((pos = pattern.indexOf(VAR_START, pos)) >= 0) {
            int endVariable;
            if (pos > prev) {
                appenders.add(new TextAppender(pattern.substring(prev, pos)));
            }
            if ((endVariable = pattern.indexOf(125, pos += VAR_START_LEN)) < 0) {
                throw new IllegalArgumentException(String.format("Syntax error in property value '%s', missing close bracket '%s' for variable beginning at col %s: ''{3}''", pattern, Character.valueOf('}'), pos - VAR_START_LEN, pattern.substring(pos - VAR_START_LEN)));
            }
            int nextVariable = pattern.indexOf(VAR_START, pos);
            int lastEndVariable = endVariable;
            boolean hasNested = false;
            while (nextVariable >= 0 && nextVariable < endVariable) {
                hasNested = true;
                if ((endVariable = pattern.indexOf(125, endVariable + 1)) < 0) {
                    throw new IllegalArgumentException(String.format("Syntax error in property value '%s', missing close bracket '%s' for variable beginning at col %s: '%s'", pattern, Character.valueOf('}'), nextVariable, pattern.substring(nextVariable, lastEndVariable)));
                }
                nextVariable = pattern.indexOf(VAR_START, nextVariable + VAR_START_LEN);
                lastEndVariable = endVariable;
            }
            String rawKey = pattern.substring(pos - VAR_START_LEN, endVariable + 1);
            String key = pattern.substring(pos, endVariable);
            int pipeIndex = key.indexOf(124);
            boolean hasKeyVariables = false;
            boolean hasDefault = false;
            boolean hasDefaultVariables = false;
            if (pipeIndex >= 0) {
                if (!hasNested) {
                    hasDefault = true;
                    hasDefaultVariables = false;
                } else {
                    int nextStartKeyVariable = key.indexOf(VAR_START);
                    boolean bl = hasKeyVariables = pipeIndex > nextStartKeyVariable;
                    if (hasKeyVariables) {
                        int nextEndKeyVariable = key.indexOf(125, nextStartKeyVariable + VAR_START_LEN);
                        pipeIndex = key.indexOf(124, pipeIndex + 1);
                        while (pipeIndex >= 0 && pipeIndex > nextStartKeyVariable) {
                            pipeIndex = key.indexOf(124, nextEndKeyVariable + 1);
                            if ((nextStartKeyVariable = key.indexOf(VAR_START, nextStartKeyVariable + VAR_START_LEN)) < 0) break;
                            if ((nextEndKeyVariable = key.indexOf(125, nextEndKeyVariable + 1)) >= 0) continue;
                            throw new IllegalArgumentException(String.format("Syntax error in property value '%s', missing close bracket '%s' for variable beginning at col %s: '%s'", pattern, Character.valueOf('}'), nextStartKeyVariable, key.substring(nextStartKeyVariable)));
                        }
                    }
                    if (pipeIndex >= 0) {
                        hasDefault = true;
                        hasDefaultVariables = key.indexOf(VAR_START, pipeIndex) >= 0;
                    }
                }
            } else {
                hasKeyVariables = hasNested;
            }
            String keyPart = null;
            String defaultPart = null;
            if (hasDefault) {
                keyPart = key.substring(0, pipeIndex).trim();
                defaultPart = key.substring(pipeIndex + 1).trim();
            } else {
                keyPart = key.trim();
            }
            appenders.add(new KeyAppender(this, rawKey, hasKeyVariables ? this.parse(keyPart) : new TextAppender(keyPart), !hasDefault ? null : (hasDefaultVariables ? this.parse(defaultPart) : new TextAppender(defaultPart))));
            pos = prev = endVariable + 1;
        }
        if (prev < pattern.length()) {
            appenders.add(new TextAppender(pattern.substring(prev)));
        }
        return appenders.size() == 1 ? (Appender)appenders.get(0) : new MixinAppender(pattern, appenders);
    }
}

