/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.variables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nnsoft.guice.rocoto.variables.AbstractAppender;
import org.nnsoft.guice.rocoto.variables.Appender;
import org.nnsoft.guice.rocoto.variables.Tree;

final class MixinAppender
extends AbstractAppender {
    private final List<Appender> appenders = new ArrayList<Appender>();

    public MixinAppender(String chunk, Appender ... appenders) {
        this(chunk, Arrays.asList(appenders));
    }

    public MixinAppender(String chunk, List<Appender> appenders) {
        super(chunk);
        this.appenders.addAll(appenders);
    }

    @Override
    public void doAppend(StringBuilder buffer, Map<String, String> configuration, Tree<Appender> context) {
        for (Appender appender : this.appenders) {
            appender.append(buffer, configuration, context);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MixinAppender) {
            MixinAppender other = (MixinAppender)obj;
            if (this.appenders.size() == other.appenders.size()) {
                return this.appenders.containsAll(other.appenders);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.appenders.hashCode();
    }

    @Override
    public boolean needsResolving() {
        for (Appender appender : this.appenders) {
            if (!appender.needsResolving()) continue;
            return true;
        }
        return false;
    }
}

