/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator.impl.clock;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.runtime.Clock;
import org.springframework.beans.factory.FactoryBean;

public class ThreadLocalClock
implements Clock {
    private static volatile ThreadLocal<Clock> THREAD_CLOCK = new ThreadLocal();
    protected FactoryBean<Clock> clockFactory;

    public ThreadLocalClock(FactoryBean<Clock> clockFactory) {
        this.clockFactory = clockFactory;
    }

    public void setCurrentTime(Date currentTime) {
        this.get().setCurrentTime(currentTime);
    }

    private Clock get() {
        if (THREAD_CLOCK.get() == null) {
            try {
                THREAD_CLOCK.set((Clock)this.clockFactory.getObject());
            }
            catch (Exception e) {
                throw new ActivitiException("Unable to get simulation clock", (Throwable)e);
            }
        }
        return THREAD_CLOCK.get();
    }

    public void setCurrentCalendar(Calendar currentTime) {
        this.get().setCurrentCalendar(currentTime);
    }

    public void reset() {
        this.get().reset();
    }

    public Date getCurrentTime() {
        return this.get().getCurrentTime();
    }

    public Calendar getCurrentCalendar() {
        return this.get().getCurrentCalendar();
    }

    public Calendar getCurrentCalendar(TimeZone timeZone) {
        return this.get().getCurrentCalendar(timeZone);
    }

    public TimeZone getCurrentTimeZone() {
        return this.get().getCurrentTimeZone();
    }
}

