/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.diagram.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.activiti.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.Lane;
import org.activiti.engine.impl.pvm.process.LaneSet;
import org.activiti.engine.impl.pvm.process.ParticipantProcess;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.apache.commons.lang3.StringUtils;
import org.restlet.resource.Get;

public class ProcessDefinitionDiagramLayoutResource
extends SecuredResource {
    private RuntimeService runtimeService = ActivitiUtil.getRuntimeService();
    private RepositoryServiceImpl repositoryService = (RepositoryServiceImpl)ActivitiUtil.getRepositoryService();
    private String processInstanceId = null;
    private String processDefinitionId = null;
    private ProcessInstance processInstance = null;
    private ProcessDefinitionEntity processDefinition;
    private List<String> highLightedFlows = Collections.emptyList();
    private List<String> highLightedActivities = Collections.emptyList();
    private Map<String, ObjectNode> subProcessInstanceMap = new HashMap<String, ObjectNode>();

    @Get(value="json")
    public ObjectNode getDiagram() {
        this.processDefinitionId = (String)this.getRequest().getAttributes().get("processDefinitionId");
        this.processInstanceId = (String)this.getRequest().getAttributes().get("processInstanceId");
        if (this.processInstanceId != null) {
            this.processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(this.processInstanceId).singleResult();
            if (this.processInstance == null) {
                return null;
            }
            this.processDefinitionId = this.processInstance.getProcessDefinitionId();
            List subProcessInstances = this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(this.processInstanceId).list();
            for (ProcessInstance subProcessInstance : subProcessInstances) {
                String subDefId = subProcessInstance.getProcessDefinitionId();
                String superExecutionId = ((ExecutionEntity)subProcessInstance).getSuperExecutionId();
                ProcessDefinitionEntity subDef = (ProcessDefinitionEntity)this.repositoryService.getDeployedProcessDefinition(subDefId);
                ObjectNode processInstanceJSON = new ObjectMapper().createObjectNode();
                processInstanceJSON.put("processInstanceId", subProcessInstance.getId());
                processInstanceJSON.put("superExecutionId", superExecutionId);
                processInstanceJSON.put("processDefinitionId", subDef.getId());
                processInstanceJSON.put("processDefinitionKey", subDef.getKey());
                processInstanceJSON.put("processDefinitionName", subDef.getName());
                this.subProcessInstanceMap.put(superExecutionId, processInstanceJSON);
            }
        }
        if (this.processDefinitionId == null) {
            throw new ActivitiException("No process definition id provided");
        }
        this.processDefinition = (ProcessDefinitionEntity)this.repositoryService.getDeployedProcessDefinition(this.processDefinitionId);
        if (this.processDefinition == null) {
            throw new ActivitiException("Process definition " + this.processDefinitionId + " could not be found");
        }
        ObjectNode responseJSON = new ObjectMapper().createObjectNode();
        JsonNode pdrJSON = this.getProcessDefinitionResponse(this.processDefinition);
        if (pdrJSON != null) {
            responseJSON.put("processDefinition", pdrJSON);
        }
        if (this.processInstance != null) {
            ArrayNode activityArray = new ObjectMapper().createArrayNode();
            ArrayNode flowsArray = new ObjectMapper().createArrayNode();
            this.highLightedActivities = this.runtimeService.getActiveActivityIds(this.processInstanceId);
            this.highLightedFlows = this.getHighLightedFlows();
            for (String activityName : this.highLightedActivities) {
                activityArray.add(activityName);
            }
            for (String flow : this.highLightedFlows) {
                flowsArray.add(flow);
            }
            responseJSON.put("highLightedActivities", (JsonNode)activityArray);
            responseJSON.put("highLightedFlows", (JsonNode)flowsArray);
        }
        if (this.processDefinition.getParticipantProcess() != null) {
            ParticipantProcess pProc = this.processDefinition.getParticipantProcess();
            ObjectNode participantProcessJSON = new ObjectMapper().createObjectNode();
            participantProcessJSON.put("id", pProc.getId());
            if (StringUtils.isNotEmpty((CharSequence)pProc.getName())) {
                participantProcessJSON.put("name", pProc.getName());
            } else {
                participantProcessJSON.put("name", "");
            }
            participantProcessJSON.put("x", pProc.getX());
            participantProcessJSON.put("y", pProc.getY());
            participantProcessJSON.put("width", pProc.getWidth());
            participantProcessJSON.put("height", pProc.getHeight());
            responseJSON.put("participantProcess", (JsonNode)participantProcessJSON);
        }
        if (this.processDefinition.getLaneSets() != null && this.processDefinition.getLaneSets().size() > 0) {
            ArrayNode laneSetArray = new ObjectMapper().createArrayNode();
            for (LaneSet laneSet : this.processDefinition.getLaneSets()) {
                ArrayNode laneArray = new ObjectMapper().createArrayNode();
                if (laneSet.getLanes() != null && laneSet.getLanes().size() > 0) {
                    for (Lane lane : laneSet.getLanes()) {
                        ObjectNode laneJSON = new ObjectMapper().createObjectNode();
                        laneJSON.put("id", lane.getId());
                        if (StringUtils.isNotEmpty((CharSequence)lane.getName())) {
                            laneJSON.put("name", lane.getName());
                        } else {
                            laneJSON.put("name", "");
                        }
                        laneJSON.put("x", lane.getX());
                        laneJSON.put("y", lane.getY());
                        laneJSON.put("width", lane.getWidth());
                        laneJSON.put("height", lane.getHeight());
                        List flowNodeIds = lane.getFlowNodeIds();
                        ArrayNode flowNodeIdsArray = new ObjectMapper().createArrayNode();
                        for (String flowNodeId : flowNodeIds) {
                            flowNodeIdsArray.add(flowNodeId);
                        }
                        laneJSON.put("flowNodeIds", (JsonNode)flowNodeIdsArray);
                        laneArray.add((JsonNode)laneJSON);
                    }
                }
                ObjectNode laneSetJSON = new ObjectMapper().createObjectNode();
                laneSetJSON.put("id", laneSet.getId());
                if (StringUtils.isNotEmpty((CharSequence)laneSet.getName())) {
                    laneSetJSON.put("name", laneSet.getName());
                } else {
                    laneSetJSON.put("name", "");
                }
                laneSetJSON.put("lanes", (JsonNode)laneArray);
                laneSetArray.add((JsonNode)laneSetJSON);
            }
            if (laneSetArray.size() > 0) {
                responseJSON.put("laneSets", (JsonNode)laneSetArray);
            }
        }
        ArrayNode sequenceFlowArray = new ObjectMapper().createArrayNode();
        ArrayNode activityArray = new ObjectMapper().createArrayNode();
        for (ActivityImpl activity : this.processDefinition.getActivities()) {
            this.getActivity(activity, activityArray, sequenceFlowArray);
        }
        responseJSON.put("activities", (JsonNode)activityArray);
        responseJSON.put("sequenceFlows", (JsonNode)sequenceFlowArray);
        return responseJSON;
    }

    private List<String> getHighLightedFlows() {
        HistoryService historyService = ActivitiUtil.getHistoryService();
        ArrayList<String> highLightedFlows = new ArrayList<String>();
        List historicActivityInstances = ((HistoricActivityInstanceQuery)historyService.createHistoricActivityInstanceQuery().processInstanceId(this.processInstanceId).orderByHistoricActivityInstanceStartTime().asc()).list();
        ArrayList<String> historicActivityInstanceList = new ArrayList<String>();
        for (HistoricActivityInstance hai : historicActivityInstances) {
            historicActivityInstanceList.add(hai.getActivityId());
        }
        List highLightedActivities = this.runtimeService.getActiveActivityIds(this.processInstanceId);
        historicActivityInstanceList.addAll(highLightedActivities);
        for (ActivityImpl activity : this.processDefinition.getActivities()) {
            int index = historicActivityInstanceList.indexOf(activity.getId());
            if (index < 0 || index + 1 >= historicActivityInstanceList.size()) continue;
            List pvmTransitionList = activity.getOutgoingTransitions();
            for (PvmTransition pvmTransition : pvmTransitionList) {
                String destinationFlowId = pvmTransition.getDestination().getId();
                if (!destinationFlowId.equals(historicActivityInstanceList.get(index + 1))) continue;
                highLightedFlows.add(pvmTransition.getId());
            }
        }
        return highLightedFlows;
    }

    private void getActivity(ActivityImpl activity, ArrayNode activityArray, ArrayNode sequenceFlowArray) {
        ObjectNode activityJSON = new ObjectMapper().createObjectNode();
        String multiInstance = (String)activity.getProperty("multiInstance");
        if (multiInstance != null && !"sequential".equals(multiInstance)) {
            multiInstance = "parallel";
        }
        ActivityBehavior activityBehavior = activity.getActivityBehavior();
        Boolean collapsed = activityBehavior instanceof CallActivityBehavior;
        Boolean expanded = (Boolean)activity.getProperty("isExpanded");
        if (expanded != null) {
            collapsed = expanded == false;
        }
        Boolean isInterrupting = null;
        if (activityBehavior instanceof BoundaryEventActivityBehavior) {
            isInterrupting = ((BoundaryEventActivityBehavior)activityBehavior).isInterrupting();
        }
        for (PvmTransition sequenceFlow : activity.getOutgoingTransitions()) {
            String flowName = (String)sequenceFlow.getProperty("name");
            boolean isHighLighted = this.highLightedFlows.contains(sequenceFlow.getId());
            boolean isConditional = sequenceFlow.getProperty("condition") != null && !((String)activity.getProperty("type")).toLowerCase().contains("gateway");
            boolean isDefault = sequenceFlow.getId().equals(activity.getProperty("default")) && ((String)activity.getProperty("type")).toLowerCase().contains("gateway");
            List waypoints = ((TransitionImpl)sequenceFlow).getWaypoints();
            ArrayNode xPointArray = new ObjectMapper().createArrayNode();
            ArrayNode yPointArray = new ObjectMapper().createArrayNode();
            for (int i = 0; i < waypoints.size(); i += 2) {
                xPointArray.add((Integer)waypoints.get(i));
                yPointArray.add((Integer)waypoints.get(i + 1));
            }
            ObjectNode flowJSON = new ObjectMapper().createObjectNode();
            flowJSON.put("id", sequenceFlow.getId());
            flowJSON.put("name", flowName);
            flowJSON.put("flow", "(" + sequenceFlow.getSource().getId() + ")--" + sequenceFlow.getId() + "-->(" + sequenceFlow.getDestination().getId() + ")");
            if (isConditional) {
                flowJSON.put("isConditional", isConditional);
            }
            if (isDefault) {
                flowJSON.put("isDefault", isDefault);
            }
            if (isHighLighted) {
                flowJSON.put("isHighLighted", isHighLighted);
            }
            flowJSON.put("xPointArray", (JsonNode)xPointArray);
            flowJSON.put("yPointArray", (JsonNode)yPointArray);
            sequenceFlowArray.add((JsonNode)flowJSON);
        }
        ArrayNode nestedActivityArray = new ObjectMapper().createArrayNode();
        for (ActivityImpl nestedActivity : activity.getActivities()) {
            nestedActivityArray.add(nestedActivity.getId());
        }
        Map properties = activity.getProperties();
        ObjectNode propertiesJSON = new ObjectMapper().createObjectNode();
        for (String key : properties.keySet()) {
            Object prop = properties.get(key);
            if (prop instanceof String) {
                propertiesJSON.put(key, (String)properties.get(key));
                continue;
            }
            if (prop instanceof Integer) {
                propertiesJSON.put(key, (Integer)properties.get(key));
                continue;
            }
            if (prop instanceof Boolean) {
                propertiesJSON.put(key, (Boolean)properties.get(key));
                continue;
            }
            if ("initial".equals(key)) {
                ActivityImpl act = (ActivityImpl)properties.get(key);
                propertiesJSON.put(key, act.getId());
                continue;
            }
            if ("timerDeclarations".equals(key)) {
                ArrayList timerDeclarations = (ArrayList)properties.get(key);
                ArrayNode timerDeclarationArray = new ObjectMapper().createArrayNode();
                if (timerDeclarations != null) {
                    for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                        ObjectNode timerDeclarationJSON = new ObjectMapper().createObjectNode();
                        timerDeclarationJSON.put("isExclusive", timerDeclaration.isExclusive());
                        if (timerDeclaration.getRepeat() != null) {
                            timerDeclarationJSON.put("repeat", timerDeclaration.getRepeat());
                        }
                        timerDeclarationJSON.put("retries", String.valueOf(timerDeclaration.getRetries()));
                        timerDeclarationJSON.put("type", timerDeclaration.getJobHandlerType());
                        timerDeclarationJSON.put("configuration", timerDeclaration.getJobHandlerConfiguration());
                        timerDeclarationArray.add((JsonNode)timerDeclarationJSON);
                    }
                }
                if (timerDeclarationArray.size() <= 0) continue;
                propertiesJSON.put(key, (JsonNode)timerDeclarationArray);
                continue;
            }
            if ("eventDefinitions".equals(key)) {
                ArrayList eventDefinitions = (ArrayList)properties.get(key);
                ArrayNode eventDefinitionsArray = new ObjectMapper().createArrayNode();
                if (eventDefinitions != null) {
                    for (EventSubscriptionDeclaration eventDefinition : eventDefinitions) {
                        ObjectNode eventDefinitionJSON = new ObjectMapper().createObjectNode();
                        if (eventDefinition.getActivityId() != null) {
                            eventDefinitionJSON.put("activityId", eventDefinition.getActivityId());
                        }
                        eventDefinitionJSON.put("eventName", eventDefinition.getEventName());
                        eventDefinitionJSON.put("eventType", eventDefinition.getEventType());
                        eventDefinitionJSON.put("isAsync", eventDefinition.isAsync());
                        eventDefinitionJSON.put("isStartEvent", eventDefinition.isStartEvent());
                        eventDefinitionsArray.add((JsonNode)eventDefinitionJSON);
                    }
                }
                if (eventDefinitionsArray.size() <= 0) continue;
                propertiesJSON.put(key, (JsonNode)eventDefinitionsArray);
                continue;
            }
            if (!"errorEventDefinitions".equals(key)) continue;
            ArrayList errorEventDefinitions = (ArrayList)properties.get(key);
            ArrayNode errorEventDefinitionsArray = new ObjectMapper().createArrayNode();
            if (errorEventDefinitions != null) {
                for (ErrorEventDefinition errorEventDefinition : errorEventDefinitions) {
                    ObjectNode errorEventDefinitionJSON = new ObjectMapper().createObjectNode();
                    if (errorEventDefinition.getErrorCode() != null) {
                        errorEventDefinitionJSON.put("errorCode", errorEventDefinition.getErrorCode());
                    } else {
                        errorEventDefinitionJSON.putNull("errorCode");
                    }
                    errorEventDefinitionJSON.put("handlerActivityId", errorEventDefinition.getHandlerActivityId());
                    errorEventDefinitionsArray.add((JsonNode)errorEventDefinitionJSON);
                }
            }
            if (errorEventDefinitionsArray.size() <= 0) continue;
            propertiesJSON.put(key, (JsonNode)errorEventDefinitionsArray);
        }
        if ("callActivity".equals(properties.get("type"))) {
            CallActivityBehavior callActivityBehavior = null;
            if (activityBehavior instanceof CallActivityBehavior) {
                callActivityBehavior = (CallActivityBehavior)activityBehavior;
            }
            if (callActivityBehavior != null) {
                List executionList;
                propertiesJSON.put("processDefinitonKey", callActivityBehavior.getProcessDefinitonKey());
                ArrayNode processInstanceArray = new ObjectMapper().createArrayNode();
                if (this.processInstance != null && (executionList = this.runtimeService.createExecutionQuery().processInstanceId(this.processInstanceId).activityId(activity.getId()).list()).size() > 0) {
                    for (Execution execution : executionList) {
                        ObjectNode processInstanceJSON = this.subProcessInstanceMap.get(execution.getId());
                        processInstanceArray.add((JsonNode)processInstanceJSON);
                    }
                }
                if (processInstanceArray.size() == 0) {
                    ProcessDefinition lastProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(callActivityBehavior.getProcessDefinitonKey()).latestVersion().singleResult();
                    ObjectNode processInstanceJSON = new ObjectMapper().createObjectNode();
                    processInstanceJSON.put("processDefinitionId", lastProcessDefinition.getId());
                    processInstanceJSON.put("processDefinitionKey", lastProcessDefinition.getKey());
                    processInstanceJSON.put("processDefinitionName", lastProcessDefinition.getName());
                    processInstanceArray.add((JsonNode)processInstanceJSON);
                }
                if (processInstanceArray.size() > 0) {
                    propertiesJSON.put("processDefinitons", (JsonNode)processInstanceArray);
                }
            }
        }
        activityJSON.put("activityId", activity.getId());
        activityJSON.put("properties", (JsonNode)propertiesJSON);
        if (multiInstance != null) {
            activityJSON.put("multiInstance", multiInstance);
        }
        if (collapsed.booleanValue()) {
            activityJSON.put("collapsed", collapsed);
        }
        if (nestedActivityArray.size() > 0) {
            activityJSON.put("nestedActivities", (JsonNode)nestedActivityArray);
        }
        if (isInterrupting != null) {
            activityJSON.put("isInterrupting", isInterrupting);
        }
        activityJSON.put("x", activity.getX());
        activityJSON.put("y", activity.getY());
        activityJSON.put("width", activity.getWidth());
        activityJSON.put("height", activity.getHeight());
        activityArray.add((JsonNode)activityJSON);
        for (ActivityImpl nestedActivity : activity.getActivities()) {
            this.getActivity(nestedActivity, activityArray, sequenceFlowArray);
        }
    }

    private JsonNode getProcessDefinitionResponse(ProcessDefinitionEntity processDefinition) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode pdrJSON = mapper.createObjectNode();
        pdrJSON.put("id", processDefinition.getId());
        pdrJSON.put("name", processDefinition.getName());
        pdrJSON.put("key", processDefinition.getKey());
        pdrJSON.put("version", processDefinition.getVersion());
        pdrJSON.put("deploymentId", processDefinition.getDeploymentId());
        pdrJSON.put("isGraphicNotationDefined", this.isGraphicNotationDefined(processDefinition));
        return pdrJSON;
    }

    private boolean isGraphicNotationDefined(ProcessDefinitionEntity processDefinition) {
        return ((ProcessDefinitionEntity)this.repositoryService.getDeployedProcessDefinition(processDefinition.getId())).isGraphicalNotationDefined();
    }
}

