/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.ProcessDefinition;

public class SetProcessDefinitionCategoryCmd
implements Command<Void> {
    protected String processDefinitionId;
    protected String category;

    public SetProcessDefinitionCategoryCmd(String processDefinitionId, String category) {
        this.processDefinitionId = processDefinitionId;
        this.category = category;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.processDefinitionId == null) {
            throw new ActivitiIllegalArgumentException("Process definition id is null");
        }
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("No process definition found for id = '" + this.processDefinitionId + "'", ProcessDefinition.class);
        }
        processDefinition.setCategory(this.category);
        DeploymentCache<ProcessDefinitionEntity> processDefinitionCache = Context.getProcessEngineConfiguration().getProcessDefinitionCache();
        if (processDefinitionCache != null) {
            processDefinitionCache.remove(this.processDefinitionId);
        }
        if (Context.getCommandContext().getEventDispatcher().isEnabled()) {
            Context.getCommandContext().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, processDefinition));
        }
        return null;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

