/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.maven.plugin.archiver;

import java.io.File;
import org.alfresco.repo.module.tool.ModuleManagementTool;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.AbstractZipUnArchiver;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class AmpUnArchiver
extends AbstractZipUnArchiver {
    @Requirement
    private LegacySupport legacySupport;
    protected File destDirectory;

    public File getDestDirectory() {
        String webappDir;
        Xpp3Dom warConfigElement;
        Xpp3Dom warPluginConfig;
        MavenSession session = this.legacySupport.getSession();
        MavenProject project = session.getCurrentProject().getExecutionProject();
        File location = new File(project.getBuild().getDirectory() + File.separator + project.getBuild().getFinalName());
        Plugin warPlugin = project.getPlugin("org.apache.maven.plugins:maven-war-plugin");
        if (warPlugin != null && (warPluginConfig = (Xpp3Dom)warPlugin.getConfiguration()) != null && (warConfigElement = warPluginConfig.getChild("webappDirectory")) != null && (webappDir = warConfigElement.getValue()) != null && !webappDir.isEmpty()) {
            location = new File(webappDir);
        }
        return location;
    }

    protected void execute() throws ArchiverException {
        try {
            File destDirectory = this.getDestDirectory();
            ModuleManagementTool mmt = new ModuleManagementTool();
            mmt.setVerbose(false);
            if (this.getDestFile() != null) {
                this.getLogger().info("Installing into destination file: " + this.getDestFile());
            }
            if (this.getDestDirectory() != null) {
                this.getLogger().info("Installing into destination folder: " + destDirectory);
            }
            File destLocation = this.getDestFile() == null || !this.getDestFile().exists() ? destDirectory : this.getDestFile();
            this.getLogger().info("Installing " + this.getSourceFile() + " into " + destLocation);
            try {
                mmt.installModule(this.getSourceFile().getAbsolutePath(), destLocation.getAbsolutePath(), false, true, false);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Problems while installing " + this.getSourceFile().getAbsolutePath() + " onto " + destLocation.getAbsolutePath(), e);
            }
            this.getLogger().debug("MMT invocation for " + this.getSourceFile().getAbsolutePath() + "complete");
        }
        catch (Exception e) {
            throw new ArchiverException("Error while expanding " + this.getSourceFile().getAbsolutePath(), (Throwable)e);
        }
    }
}

