/*
 * Decompiled with CFR 0.152.
 */
package org.antipathy.scalafmtmvn;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.antipathy.scalafmtmvn.Formatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="format")
public class FormatMojo
extends AbstractMojo {
    @Parameter(property="format.configLocation")
    private String configLocation;
    @Parameter(property="format.parameters")
    private String parameters;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip flag set, skipping formatting");
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.configLocation)) {
            this.getLog().info((CharSequence)"No configuration file specified");
            this.configLocation = null;
        } else {
            this.getLog().info((CharSequence)("Formatting with configuration: " + this.configLocation));
        }
        if (!StringUtils.isBlank((CharSequence)this.parameters)) {
            this.getLog().info((CharSequence)(" and options: " + this.parameters));
        } else {
            this.parameters = null;
        }
        Object[] sourceRoots = this.getSourceRoots();
        this.getLog().info((CharSequence)(" sources: " + Arrays.toString(sourceRoots)));
        if (sourceRoots.length == 0) {
            this.getLog().info((CharSequence)"No sources, skipping formatting");
            return;
        }
        try {
            Formatter.format(this.configLocation, this.parameters, (String[])sourceRoots);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error formatting Scala files", e);
        }
    }

    private String[] getSourceRoots() {
        ArrayList<String> sourceRoots = new ArrayList<String>();
        if (this.project.getCompileSourceRoots() != null) {
            sourceRoots.addAll(this.project.getCompileSourceRoots());
        }
        if (this.project.getTestCompileSourceRoots() != null) {
            sourceRoots.addAll(this.project.getTestCompileSourceRoots());
        }
        FormatMojo.removeNonExistingPaths(sourceRoots);
        return sourceRoots.toArray(new String[sourceRoots.size()]);
    }

    private static void removeNonExistingPaths(List<String> paths) {
        Iterator<String> ite = paths.iterator();
        while (ite.hasNext()) {
            if (Files.exists(Paths.get(ite.next(), new String[0]), new LinkOption[0])) continue;
            ite.remove();
        }
    }
}

