/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.TransactionInProgressException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.LocalTransactionEventListener;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.DataArrayResponse;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.IntegerResponse;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionContext
implements XAResource {
    private static final Log LOG = LogFactory.getLog(TransactionContext.class);
    private static final ConcurrentHashMap<TransactionId, List<TransactionContext>> ENDED_XA_TRANSACTION_CONTEXTS = new ConcurrentHashMap();
    private final ActiveMQConnection connection;
    private final LongSequenceGenerator localTransactionIdGenerator;
    private final ConnectionId connectionId;
    private List<Synchronization> synchronizations;
    private Xid associatedXid;
    private TransactionId transactionId;
    private LocalTransactionEventListener localTransactionEventListener;

    public TransactionContext(ActiveMQConnection connection) {
        this.connection = connection;
        this.localTransactionIdGenerator = connection.getLocalTransactionIdGenerator();
        this.connectionId = connection.getConnectionInfo().getConnectionId();
    }

    public boolean isInXATransaction() {
        return this.transactionId != null && this.transactionId.isXATransaction();
    }

    public boolean isInLocalTransaction() {
        return this.transactionId != null && this.transactionId.isLocalTransaction();
    }

    public boolean isInTransaction() {
        return this.transactionId != null;
    }

    public LocalTransactionEventListener getLocalTransactionEventListener() {
        return this.localTransactionEventListener;
    }

    public void setLocalTransactionEventListener(LocalTransactionEventListener localTransactionEventListener) {
        this.localTransactionEventListener = localTransactionEventListener;
    }

    public void addSynchronization(Synchronization s) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<Synchronization>(10);
        }
        this.synchronizations.add(s);
    }

    private void afterRollback() throws JMSException {
        if (this.synchronizations == null) {
            return;
        }
        int size = this.synchronizations.size();
        try {
            for (int i = 0; i < size; ++i) {
                this.synchronizations.get(i).afterRollback();
            }
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Throwable e) {
            throw JMSExceptionSupport.create(e);
        }
        finally {
            this.synchronizations = null;
        }
    }

    private void afterCommit() throws JMSException {
        if (this.synchronizations == null) {
            return;
        }
        int size = this.synchronizations.size();
        try {
            for (int i = 0; i < size; ++i) {
                this.synchronizations.get(i).afterCommit();
            }
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Throwable e) {
            throw JMSExceptionSupport.create(e);
        }
        finally {
            this.synchronizations = null;
        }
    }

    private void beforeEnd() throws JMSException {
        if (this.synchronizations == null) {
            return;
        }
        int size = this.synchronizations.size();
        try {
            for (int i = 0; i < size; ++i) {
                this.synchronizations.get(i).beforeEnd();
            }
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Throwable e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public void begin() throws JMSException {
        if (this.isInXATransaction()) {
            throw new TransactionInProgressException("Cannot start local transaction.  XA transaction is already in progress.");
        }
        if (this.transactionId == null) {
            this.synchronizations = null;
            this.transactionId = new LocalTransactionId(this.connectionId, this.localTransactionIdGenerator.getNextSequenceId());
            TransactionInfo info = new TransactionInfo(this.getConnectionId(), this.transactionId, 0);
            this.connection.ensureConnectionInfoSent();
            this.connection.asyncSendPacket(info);
            if (this.localTransactionEventListener != null) {
                this.localTransactionEventListener.beginEvent();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Begin:" + this.transactionId);
            }
        }
    }

    public void rollback() throws JMSException {
        if (this.isInXATransaction()) {
            throw new TransactionInProgressException("Cannot rollback() if an XA transaction is already in progress ");
        }
        this.beforeEnd();
        if (this.transactionId != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Rollback: " + this.transactionId + " syncCount: " + (this.synchronizations != null ? this.synchronizations.size() : 0));
            }
            TransactionInfo info = new TransactionInfo(this.getConnectionId(), this.transactionId, 4);
            this.transactionId = null;
            this.connection.syncSendPacket(info);
            if (this.localTransactionEventListener != null) {
                this.localTransactionEventListener.rollbackEvent();
            }
        }
        this.afterRollback();
    }

    public void commit() throws JMSException {
        if (this.isInXATransaction()) {
            throw new TransactionInProgressException("Cannot commit() if an XA transaction is already in progress ");
        }
        this.beforeEnd();
        if (this.transactionId != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Commit: " + this.transactionId + " syncCount: " + (this.synchronizations != null ? this.synchronizations.size() : 0));
            }
            TransactionInfo info = new TransactionInfo(this.getConnectionId(), this.transactionId, 2);
            this.transactionId = null;
            this.syncSendPacketWithInterruptionHandling(info);
            if (this.localTransactionEventListener != null) {
                this.localTransactionEventListener.commitEvent();
            }
            this.afterCommit();
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start: " + xid);
        }
        if (this.isInLocalTransaction()) {
            throw new XAException(-6);
        }
        if (this.associatedXid != null) {
            throw new XAException(-6);
        }
        this.synchronizations = null;
        this.setXid(xid);
    }

    private ConnectionId getConnectionId() {
        return this.connection.getConnectionInfo().getConnectionId();
    }

    public void end(Xid xid, int flags) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("End: " + xid);
        }
        if (this.isInLocalTransaction()) {
            throw new XAException(-6);
        }
        if ((flags & 0x22000000) != 0) {
            if (!this.equals(this.associatedXid, xid)) {
                throw new XAException(-6);
            }
            try {
                this.beforeEnd();
            }
            catch (JMSException e) {
                throw this.toXAException(e);
            }
            this.setXid(null);
        } else if ((flags & 0x4000000) == 0x4000000) {
            if (this.equals(this.associatedXid, xid)) {
                try {
                    this.beforeEnd();
                }
                catch (JMSException e) {
                    throw this.toXAException(e);
                }
                this.setXid(null);
            }
        } else {
            throw new XAException(-5);
        }
    }

    private boolean equals(Xid xid1, Xid xid2) {
        if (xid1 == xid2) {
            return true;
        }
        if (xid1 == null ^ xid2 == null) {
            return false;
        }
        return xid1.getFormatId() == xid2.getFormatId() && Arrays.equals(xid1.getBranchQualifier(), xid2.getBranchQualifier()) && Arrays.equals(xid1.getGlobalTransactionId(), xid2.getGlobalTransactionId());
    }

    public int prepare(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Prepare: " + xid);
        }
        if (xid == null || this.equals(this.associatedXid, xid)) {
            throw new XAException(-6);
        }
        XATransactionId x = new XATransactionId(xid);
        try {
            TransactionInfo info = new TransactionInfo(this.getConnectionId(), x, 1);
            IntegerResponse response = (IntegerResponse)this.syncSendPacketWithInterruptionHandling(info);
            return response.getResult();
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rollback: " + xid);
        }
        if (xid == null) {
            throw new XAException(-6);
        }
        XATransactionId x = this.equals(this.associatedXid, xid) ? (XATransactionId)this.transactionId : new XATransactionId(xid);
        try {
            this.connection.checkClosedOrFailed();
            this.connection.ensureConnectionInfoSent();
            TransactionInfo info = new TransactionInfo(this.getConnectionId(), x, 4);
            this.syncSendPacketWithInterruptionHandling(info);
            List<TransactionContext> l = ENDED_XA_TRANSACTION_CONTEXTS.remove(x);
            if (l != null && !l.isEmpty()) {
                for (TransactionContext ctx : l) {
                    ctx.afterRollback();
                }
            }
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Commit: " + xid);
        }
        if (xid == null || this.equals(this.associatedXid, xid)) {
            throw new XAException(-6);
        }
        XATransactionId x = new XATransactionId(xid);
        try {
            this.connection.checkClosedOrFailed();
            this.connection.ensureConnectionInfoSent();
            TransactionInfo info = new TransactionInfo(this.getConnectionId(), x, onePhase ? (byte)2 : 3);
            this.syncSendPacketWithInterruptionHandling(info);
            List<TransactionContext> l = ENDED_XA_TRANSACTION_CONTEXTS.remove(x);
            if (l != null && !l.isEmpty()) {
                for (TransactionContext ctx : l) {
                    ctx.afterCommit();
                }
            }
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public void forget(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forget: " + xid);
        }
        if (xid == null) {
            throw new XAException(-6);
        }
        XATransactionId x = this.equals(this.associatedXid, xid) ? (XATransactionId)this.transactionId : new XATransactionId(xid);
        TransactionInfo info = new TransactionInfo(this.getConnectionId(), x, 6);
        try {
            this.syncSendPacketWithInterruptionHandling(info);
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (xaResource == null) {
            return false;
        }
        if (!(xaResource instanceof TransactionContext)) {
            return false;
        }
        TransactionContext xar = (TransactionContext)xaResource;
        try {
            return this.getResourceManagerId().equals(xar.getResourceManagerId());
        }
        catch (Throwable e) {
            throw (XAException)new XAException("Could not get resource manager id.").initCause(e);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Recover: " + flag);
        }
        TransactionInfo info = new TransactionInfo(this.getConnectionId(), null, 5);
        try {
            Xid[] answer;
            this.connection.checkClosedOrFailed();
            this.connection.ensureConnectionInfoSent();
            DataArrayResponse receipt = (DataArrayResponse)this.connection.syncSendPacket(info);
            DataStructure[] data = receipt.getData();
            if (data instanceof XATransactionId[]) {
                answer = (XATransactionId[])data;
            } else {
                answer = new XATransactionId[data.length];
                System.arraycopy(data, 0, answer, 0, data.length);
            }
            return answer;
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    private String getResourceManagerId() throws JMSException {
        return this.connection.getResourceManagerId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setXid(Xid xid) throws XAException {
        try {
            this.connection.checkClosedOrFailed();
            this.connection.ensureConnectionInfoSent();
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
        if (xid != null) {
            this.associatedXid = xid;
            this.transactionId = new XATransactionId(xid);
            TransactionInfo info = new TransactionInfo(this.connectionId, this.transactionId, 0);
            try {
                this.connection.asyncSendPacket(info);
                if (!LOG.isDebugEnabled()) return;
                LOG.debug("Started XA transaction: " + this.transactionId);
                return;
            }
            catch (JMSException e) {
                throw this.toXAException(e);
            }
        }
        if (this.transactionId != null) {
            TransactionInfo info = new TransactionInfo(this.connectionId, this.transactionId, 7);
            try {
                this.syncSendPacketWithInterruptionHandling(info);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ended XA transaction: " + this.transactionId);
                }
            }
            catch (JMSException e) {
                throw this.toXAException(e);
            }
            List<TransactionContext> l = ENDED_XA_TRANSACTION_CONTEXTS.get(this.transactionId);
            if (l == null) {
                l = new ArrayList<TransactionContext>(3);
                ENDED_XA_TRANSACTION_CONTEXTS.put(this.transactionId, l);
                l.add(this);
            } else if (!l.contains(this)) {
                l.add(this);
            }
        }
        this.associatedXid = null;
        this.transactionId = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response syncSendPacketWithInterruptionHandling(Command command) throws JMSException {
        try {
            return this.connection.syncSendPacket(command);
        }
        catch (JMSException e) {
            if (e.getLinkedException() instanceof InterruptedIOException) {
                try {
                    Thread.interrupted();
                    Response response = this.connection.syncSendPacket(command);
                    return response;
                }
                finally {
                    Thread.currentThread().interrupt();
                }
            }
            throw e;
        }
    }

    private XAException toXAException(JMSException e) {
        if (e.getCause() != null && e.getCause() instanceof XAException) {
            XAException original = (XAException)e.getCause();
            XAException xae = new XAException(original.getMessage());
            xae.errorCode = original.errorCode;
            xae.initCause(original);
            return xae;
        }
        XAException xae = new XAException(e.getMessage());
        xae.errorCode = -7;
        xae.initCause(e);
        return xae;
    }

    public ActiveMQConnection getConnection() {
        return this.connection;
    }

    public void cleanup() {
        this.associatedXid = null;
        this.transactionId = null;
    }
}

