/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import javax.jms.JMSException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.DestinationView;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.jmx.OpenTypeSupport;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;

public class QueueView
extends DestinationView
implements QueueViewMBean {
    public QueueView(ManagedRegionBroker broker, Queue destination) {
        super(broker, destination);
    }

    public CompositeData getMessage(String messageId) throws OpenDataException {
        Message rc = ((Queue)this.destination).getMessage(messageId);
        if (rc == null) {
            return null;
        }
        return OpenTypeSupport.convert(rc);
    }

    public void purge() throws Exception {
        ((Queue)this.destination).purge();
    }

    public boolean removeMessage(String messageId) throws Exception {
        return ((Queue)this.destination).removeMessage(messageId);
    }

    public int removeMatchingMessages(String selector) throws Exception {
        return ((Queue)this.destination).removeMatchingMessages(selector);
    }

    public int removeMatchingMessages(String selector, int maximumMessages) throws Exception {
        return ((Queue)this.destination).removeMatchingMessages(selector, maximumMessages);
    }

    public boolean copyMessageTo(String messageId, String destinationName) throws Exception {
        ConnectionContext context = BrokerView.getConnectionContext(this.broker.getContextBroker());
        ActiveMQDestination toDestination = ActiveMQDestination.createDestination(destinationName, (byte)1);
        return ((Queue)this.destination).copyMessageTo(context, messageId, toDestination);
    }

    public int copyMatchingMessagesTo(String selector, String destinationName) throws Exception {
        ConnectionContext context = BrokerView.getConnectionContext(this.broker.getContextBroker());
        ActiveMQDestination toDestination = ActiveMQDestination.createDestination(destinationName, (byte)1);
        return ((Queue)this.destination).copyMatchingMessagesTo(context, selector, toDestination);
    }

    public int copyMatchingMessagesTo(String selector, String destinationName, int maximumMessages) throws Exception {
        ConnectionContext context = BrokerView.getConnectionContext(this.broker.getContextBroker());
        ActiveMQDestination toDestination = ActiveMQDestination.createDestination(destinationName, (byte)1);
        return ((Queue)this.destination).copyMatchingMessagesTo(context, selector, toDestination, maximumMessages);
    }

    public boolean moveMessageTo(String messageId, String destinationName) throws Exception {
        ConnectionContext context = BrokerView.getConnectionContext(this.broker.getContextBroker());
        ActiveMQDestination toDestination = ActiveMQDestination.createDestination(destinationName, (byte)1);
        return ((Queue)this.destination).moveMessageTo(context, messageId, toDestination);
    }

    public int moveMatchingMessagesTo(String selector, String destinationName) throws Exception {
        ConnectionContext context = BrokerView.getConnectionContext(this.broker.getContextBroker());
        ActiveMQDestination toDestination = ActiveMQDestination.createDestination(destinationName, (byte)1);
        return ((Queue)this.destination).moveMatchingMessagesTo(context, selector, toDestination);
    }

    public int moveMatchingMessagesTo(String selector, String destinationName, int maximumMessages) throws Exception {
        ConnectionContext context = BrokerView.getConnectionContext(this.broker.getContextBroker());
        ActiveMQDestination toDestination = ActiveMQDestination.createDestination(destinationName, (byte)1);
        return ((Queue)this.destination).moveMatchingMessagesTo(context, selector, toDestination, maximumMessages);
    }

    public boolean retryMessage(String messageId) throws Exception {
        Queue queue = (Queue)this.destination;
        Message rc = queue.getMessage(messageId);
        if (rc != null) {
            rc = rc.copy();
            rc.getMessage().setRedeliveryCounter(0);
            ActiveMQDestination originalDestination = rc.getOriginalDestination();
            if (originalDestination != null) {
                ConnectionContext context = BrokerView.getConnectionContext(this.broker.getContextBroker());
                return queue.moveMessageTo(context, rc, originalDestination);
            }
            throw new JMSException("No original destination for message: " + messageId);
        }
        throw new JMSException("Could not find message: " + messageId);
    }

    public int cursorSize() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() != null) {
            return queue.getMessages().size();
        }
        return 0;
    }

    public boolean doesCursorHaveMessagesBuffered() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() != null) {
            return queue.getMessages().hasMessagesBufferedToDeliver();
        }
        return false;
    }

    public boolean doesCursorHaveSpace() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() != null) {
            return queue.getMessages().hasSpace();
        }
        return false;
    }

    public long getCursorMemoryUsage() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() != null && queue.getMessages().getSystemUsage() != null) {
            return queue.getMessages().getSystemUsage().getMemoryUsage().getUsage();
        }
        return 0L;
    }

    public int getCursorPercentUsage() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() != null && queue.getMessages().getSystemUsage() != null) {
            return queue.getMessages().getSystemUsage().getMemoryUsage().getPercentUsage();
        }
        return 0;
    }

    public boolean isCursorFull() {
        Queue queue = (Queue)this.destination;
        if (queue.getMessages() != null) {
            return queue.getMessages().isFull();
        }
        return false;
    }
}

