/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import javax.jms.InvalidSelectorException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.QueueSubscription;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.usage.SystemUsage;

public class QueueBrowserSubscription
extends QueueSubscription {
    int queueRefs;
    boolean browseDone;
    boolean destinationsAdded;

    public QueueBrowserSubscription(Broker broker, SystemUsage usageManager, ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        super(broker, usageManager, context, info);
    }

    protected boolean canDispatch(MessageReference node) {
        return !((QueueMessageReference)node).isAcked();
    }

    public synchronized String toString() {
        return "QueueBrowserSubscription: consumer=" + this.info.getConsumerId() + ", destinations=" + this.destinations.size() + ", dispatched=" + this.dispatched.size() + ", delivered=" + this.prefetchExtension + ", pending=" + this.getPendingQueueSize();
    }

    public synchronized void destinationsAdded() throws Exception {
        this.destinationsAdded = true;
        this.checkDone();
    }

    private void checkDone() throws Exception {
        if (!this.browseDone && this.queueRefs == 0 && this.destinationsAdded) {
            this.browseDone = true;
            this.add(QueueMessageReference.NULL_MESSAGE);
        }
    }

    public boolean matches(MessageReference node, MessageEvaluationContext context) throws IOException {
        return !this.browseDone && super.matches(node, context);
    }

    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference n) throws IOException {
    }

    public synchronized void incrementQueueRef() {
        ++this.queueRefs;
    }

    public synchronized void decrementQueueRef() throws Exception {
        --this.queueRefs;
        this.checkDone();
    }
}

