/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.nio.NIOTransportFactory;
import org.apache.activemq.transport.stomp.LegacyFrameTranslator;
import org.apache.activemq.transport.stomp.StompNIOTransport;
import org.apache.activemq.transport.stomp.StompTransportFilter;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.transport.tcp.TcpTransportServer;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.activemq.xbean.XBeanBrokerService;
import org.springframework.context.ApplicationContext;

public class StompNIOTransportFactory
extends NIOTransportFactory
implements BrokerServiceAware {
    private ApplicationContext applicationContext = null;

    protected String getDefaultWireFormatType() {
        return "stomp";
    }

    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer(this, location, serverSocketFactory){

            protected Transport createTransport(Socket socket, WireFormat format) throws IOException {
                return new StompNIOTransport(format, socket);
            }
        };
    }

    protected TcpTransport createTcpTransport(WireFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new StompNIOTransport(wf, socketFactory, location, localLocation);
    }

    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        transport = new StompTransportFilter(transport, new LegacyFrameTranslator(), this.applicationContext);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format, options);
    }

    protected boolean isUseInactivityMonitor(Transport transport) {
        return false;
    }

    public void setBrokerService(BrokerService brokerService) {
        if (brokerService instanceof XBeanBrokerService) {
            this.applicationContext = ((XBeanBrokerService)brokerService).getApplicationContext();
        }
    }
}

