/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.SuppressReplyException;
import org.apache.activemq.util.DefaultIOExceptionHandler;
import org.junit.Assert;
import org.junit.Test;

public class DefaultIOExceptionHandlerTest {
    DefaultIOExceptionHandler underTest = new DefaultIOExceptionHandler();

    @Test
    public void testHandleWithShutdownOnExit() throws Exception {
        this.doTest(true);
    }

    @Test
    public void testHandleWithOutShutdownOnExit() throws Exception {
        this.doTest(false);
    }

    protected void doTest(boolean exitPlease) throws Exception {
        final CountDownLatch stopCalled = new CountDownLatch(1);
        final AtomicBoolean shutdownOnExitSet = new AtomicBoolean(false);
        this.underTest.setSystemExitOnShutdown(exitPlease);
        this.underTest.setBrokerService(new BrokerService(){

            public void stop() throws Exception {
                shutdownOnExitSet.set(this.isSystemExitOnShutdown());
                stopCalled.countDown();
                this.setSystemExitOnShutdown(false);
                super.stop();
            }
        });
        try {
            this.underTest.handle(new IOException("cause stop"));
            Assert.fail((String)"Expect suppress reply exception");
        }
        catch (SuppressReplyException suppressReplyException) {
            // empty catch block
        }
        Assert.assertTrue((String)"stop called on time", (boolean)stopCalled.await(10L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"exit on shutdown set", (Object)exitPlease, (Object)shutdownOnExitSet.get());
    }
}

