/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.AbstractAuthenticationBroker;
import org.apache.activemq.security.SecurityContext;

public class SimpleAuthenticationBroker
extends AbstractAuthenticationBroker {
    private boolean anonymousAccessAllowed = false;
    private String anonymousUser;
    private String anonymousGroup;
    private final Map<String, String> userPasswords;
    private final Map<String, Set<Principal>> userGroups;

    public SimpleAuthenticationBroker(Broker next, Map<String, String> userPasswords, Map<String, Set<Principal>> userGroups) {
        super(next);
        this.userPasswords = userPasswords;
        this.userGroups = userGroups;
    }

    public void setAnonymousAccessAllowed(boolean anonymousAccessAllowed) {
        this.anonymousAccessAllowed = anonymousAccessAllowed;
    }

    public void setAnonymousUser(String anonymousUser) {
        this.anonymousUser = anonymousUser;
    }

    public void setAnonymousGroup(String anonymousGroup) {
        this.anonymousGroup = anonymousGroup;
    }

    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        SecurityContext s = context.getSecurityContext();
        if (s == null) {
            if (this.anonymousAccessAllowed && info.getUserName() == null && info.getPassword() == null) {
                info.setUserName(this.anonymousUser);
                s = new SecurityContext(info.getUserName()){

                    @Override
                    public Set<Principal> getPrincipals() {
                        HashSet<Principal> groups = new HashSet<Principal>();
                        groups.add((Principal)new GroupPrincipal(SimpleAuthenticationBroker.this.anonymousGroup));
                        return groups;
                    }
                };
            } else {
                String pw = this.userPasswords.get(info.getUserName());
                if (pw == null || !pw.equals(info.getPassword())) {
                    throw new SecurityException("User name [" + info.getUserName() + "] or password is invalid.");
                }
                final Set<Principal> groups = this.userGroups.get(info.getUserName());
                s = new SecurityContext(info.getUserName()){

                    @Override
                    public Set<Principal> getPrincipals() {
                        return groups;
                    }
                };
            }
            context.setSecurityContext(s);
            this.securityContexts.add(s);
        }
        try {
            super.addConnection(context, info);
        }
        catch (Exception e) {
            this.securityContexts.remove(s);
            context.setSecurityContext(null);
            throw e;
        }
    }
}

