/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource.internal;

import java.io.IOException;
import org.linkedin.util.io.PathUtils;
import org.linkedin.util.io.resource.AcceptAllResourceFilter;
import org.linkedin.util.io.resource.Resource;
import org.linkedin.util.io.resource.ResourceFilter;
import org.linkedin.util.io.resource.internal.InternalResource;
import org.linkedin.util.io.resource.internal.InternalResourceProvider;
import org.linkedin.util.io.resource.internal.ResourceProvider;

public abstract class AbstractResource
implements InternalResource {
    private final InternalResourceProvider _resourceProvider;
    private final String _path;

    protected AbstractResource(InternalResourceProvider resourceProvider, String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(path + " must start with /");
        }
        if (resourceProvider == null) {
            throw new NullPointerException("resource provider cannot be null");
        }
        this._resourceProvider = resourceProvider;
        this._path = path;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public ResourceProvider getResourceProvider() {
        return this._resourceProvider;
    }

    @Override
    public final Resource[] list() throws IOException {
        return this.list(AcceptAllResourceFilter.INSTANCE);
    }

    @Override
    public Resource createRelative(String relativePath) {
        return this._resourceProvider.createRelative(this, relativePath);
    }

    @Override
    public Resource chroot(String relativePath) {
        return this._resourceProvider.chroot((InternalResource)this.createRelative(relativePath));
    }

    @Override
    public Resource getParentResource() {
        return this._resourceProvider.getParentResource(this);
    }

    @Override
    public Resource getRootResource() {
        return this._resourceProvider.getRootResource();
    }

    @Override
    public Resource[] list(ResourceFilter filter) throws IOException {
        return this._resourceProvider.list(this, filter);
    }

    @Override
    public long lastModified() {
        if (!this.exists()) {
            return 0L;
        }
        try {
            return this.getInfo().getLastModified();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public boolean isModifiedSince(long time) {
        return this.lastModified() > time;
    }

    @Override
    public long length() {
        if (!this.exists()) {
            return 0L;
        }
        try {
            return this.getInfo().getContentLength();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public String getFilename() {
        String path = PathUtils.removeTrailingSlash(this._path);
        int idx = path.lastIndexOf("/");
        if (idx >= 0) {
            path = path.substring(idx + 1);
        }
        return path;
    }

    public String toString() {
        return this.toURI().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractResource that = (AbstractResource)o;
        if (!this._path.equals(that._path)) {
            return false;
        }
        return this._resourceProvider.equals(that._resourceProvider);
    }

    public int hashCode() {
        int result = this._resourceProvider.hashCode();
        result = 31 * result + this._path.hashCode();
        return result;
    }
}

