/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.advisory;

import java.util.ArrayList;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.ConstantPendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AdvisoryTempDestinationTests {
    protected static final int MESSAGE_COUNT = 2000;
    protected static final int EXPIRE_MESSAGE_PERIOD = 10000;
    protected BrokerService broker;
    protected Connection connection;
    protected String connectionURI;
    protected int topicCount;

    @Test(timeout=60000L)
    public void testNoSlowConsumerAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        TemporaryQueue queue = s.createTemporaryQueue();
        MessageConsumer consumer = s.createConsumer((Destination)queue);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
            }
        });
        ActiveMQTopic advisoryTopic = AdvisorySupport.getSlowConsumerAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        s = this.connection.createSession(false, 1);
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)queue);
        for (int i = 0; i < 2000; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNull((Object)msg);
    }

    @Test(timeout=60000L)
    public void testSlowConsumerAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        TemporaryQueue queue = s.createTemporaryQueue();
        MessageConsumer consumer = s.createConsumer((Destination)queue);
        Assert.assertNotNull((Object)consumer);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getSlowConsumerAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        s = this.connection.createSession(false, 1);
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)queue);
        for (int i = 0; i < 2000; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
    }

    @Test(timeout=60000L)
    public void testMessageDeliveryAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        TemporaryQueue queue = s.createTemporaryQueue();
        MessageConsumer consumer = s.createConsumer((Destination)queue);
        Assert.assertNotNull((Object)consumer);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getMessageDeliveredAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)queue);
        BytesMessage m = s.createBytesMessage();
        m.writeBytes(new byte[1024]);
        producer.send((Message)m);
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
    }

    @Test(timeout=60000L)
    public void testTempMessageConsumedAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        TemporaryQueue queue = s.createTemporaryQueue();
        MessageConsumer consumer = s.createConsumer((Destination)queue);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getMessageConsumedAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)queue);
        BytesMessage m = s.createBytesMessage();
        m.writeBytes(new byte[1024]);
        producer.send((Message)m);
        String id = m.getJMSMessageID();
        Message msg = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        ActiveMQMessage message = (ActiveMQMessage)msg;
        ActiveMQMessage payload = (ActiveMQMessage)message.getDataStructure();
        String originalId = payload.getJMSMessageID();
        Assert.assertEquals((Object)originalId, (Object)id);
    }

    @Test(timeout=60000L)
    public void testMessageExpiredAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        Queue queue = s.createQueue(this.getClass().getName());
        MessageConsumer consumer = s.createConsumer((Destination)queue);
        Assert.assertNotNull((Object)consumer);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getExpiredMessageTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)queue);
        producer.setTimeToLive(1L);
        for (int i = 0; i < 2000; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        Message msg = advisoryConsumer.receive(10000L);
        Assert.assertNotNull((Object)msg);
    }

    @Before
    public void setUp() throws Exception {
        this.broker = this.createBroker();
        this.connectionURI = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        this.connection = factory.createConnection();
        this.connection.start();
    }

    @After
    public void tearDown() throws Exception {
        this.connection.close();
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.connectionURI);
        return cf;
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        this.configureBroker(answer);
        answer.start();
        return answer;
    }

    protected void configureBroker(BrokerService answer) throws Exception {
        answer.setPersistent(false);
        ConstantPendingMessageLimitStrategy strategy = new ConstantPendingMessageLimitStrategy();
        strategy.setLimit(10);
        PolicyEntry tempQueueEntry = this.createPolicyEntry(strategy);
        tempQueueEntry.setTempQueue(true);
        PolicyEntry tempTopicEntry = this.createPolicyEntry(strategy);
        tempTopicEntry.setTempTopic(true);
        PolicyMap pMap = new PolicyMap();
        ArrayList<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
        policyEntries.add(tempQueueEntry);
        policyEntries.add(tempTopicEntry);
        pMap.setPolicyEntries(policyEntries);
        answer.setDestinationPolicy(pMap);
        answer.addConnector("tcp://0.0.0.0:0");
        answer.setDeleteAllMessagesOnStartup(true);
    }

    private PolicyEntry createPolicyEntry(ConstantPendingMessageLimitStrategy strategy) {
        PolicyEntry policy = new PolicyEntry();
        policy.setExpireMessagesPeriod(10000L);
        policy.setAdvisoryForFastProducers(true);
        policy.setAdvisoryForConsumed(true);
        policy.setAdvisoryForDelivery(true);
        policy.setAdvisoryForDiscardingMessages(true);
        policy.setAdvisoryForSlowConsumers(true);
        policy.setAdvisoryWhenFull(true);
        policy.setProducerFlowControl(false);
        policy.setPendingMessageLimitStrategy((PendingMessageLimitStrategy)strategy);
        return policy;
    }
}

