/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.blob;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.jms.JMSException;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.blob.FTPBlobDownloadStrategy;
import org.apache.activemq.blob.FTPTestSupport;
import org.apache.activemq.command.ActiveMQBlobMessage;

public class FTPBlobDownloadStrategyTest
extends FTPTestSupport {
    final int FILE_SIZE = 327670;

    public void testDownload() throws Exception {
        this.setConnection();
        File uploadFile = new File(this.ftpHomeDirFile, "test.txt");
        FileWriter wrt = new FileWriter(uploadFile);
        wrt.write("hello world");
        for (int ix = 0; ix < 327670; ++ix) {
            wrt.write("a");
        }
        wrt.close();
        ActiveMQBlobMessage message = new ActiveMQBlobMessage();
        BlobTransferPolicy transferPolicy = new BlobTransferPolicy();
        transferPolicy.setUploadUrl(this.ftpUrl);
        FTPBlobDownloadStrategy strategy = new FTPBlobDownloadStrategy(transferPolicy);
        try {
            message.setURL(new URL(this.ftpUrl + "test.txt"));
            InputStream stream = strategy.getInputStream(message);
            int i = stream.read();
            StringBuilder sb = new StringBuilder(2048);
            while (i != -1) {
                sb.append((char)i);
                i = stream.read();
            }
            FTPBlobDownloadStrategyTest.assertEquals((String)"hello world", (String)sb.toString().substring(0, "hello world".length()));
            FTPBlobDownloadStrategyTest.assertEquals((int)327670, (int)sb.toString().substring("hello world".length()).length());
            FTPBlobDownloadStrategyTest.assertTrue((boolean)uploadFile.exists());
            strategy.deleteFile(message);
            FTPBlobDownloadStrategyTest.assertFalse((boolean)uploadFile.exists());
        }
        catch (Exception e) {
            e.printStackTrace();
            FTPBlobDownloadStrategyTest.assertTrue((boolean)false);
        }
    }

    public void testWrongAuthentification() throws Exception {
        this.setConnection();
        ActiveMQBlobMessage message = new ActiveMQBlobMessage();
        BlobTransferPolicy transferPolicy = new BlobTransferPolicy();
        transferPolicy.setUploadUrl(this.ftpUrl);
        FTPBlobDownloadStrategy strategy = new FTPBlobDownloadStrategy(transferPolicy);
        try {
            message.setURL(new URL("ftp://" + this.userNamePass + "_wrong:" + this.userNamePass + "@localhost:" + this.ftpPort + "/ftptest/"));
            strategy.getInputStream(message);
        }
        catch (JMSException e) {
            FTPBlobDownloadStrategyTest.assertEquals((String)"Wrong Exception", (String)"Cant Authentificate to FTP-Server", (String)e.getMessage());
            return;
        }
        catch (Exception e) {
            System.out.println(e);
            FTPBlobDownloadStrategyTest.assertTrue((String)("Wrong Exception " + e), (boolean)false);
            return;
        }
        FTPBlobDownloadStrategyTest.assertTrue((String)"Expect Exception", (boolean)false);
    }

    public void testWrongFTPPort() throws Exception {
        this.setConnection();
        ActiveMQBlobMessage message = new ActiveMQBlobMessage();
        BlobTransferPolicy transferPolicy = new BlobTransferPolicy();
        transferPolicy.setUploadUrl(this.ftpUrl);
        FTPBlobDownloadStrategy strategy = new FTPBlobDownloadStrategy(transferPolicy);
        try {
            message.setURL(new URL("ftp://" + this.userNamePass + ":" + this.userNamePass + "@localhost:" + 422 + "/ftptest/"));
            strategy.getInputStream(message);
        }
        catch (IOException e) {
            FTPBlobDownloadStrategyTest.assertEquals((String)"Wrong Exception", (String)"The message URL port is incorrect", (String)e.getMessage());
            return;
        }
        FTPBlobDownloadStrategyTest.assertTrue((String)"Expect Exception", (boolean)false);
    }
}

