/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.io.File;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.ft.QueueMasterSlaveTestSupport;
import org.apache.activemq.leveldb.LevelDBStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.util.Wait;

public class QueueMasterSlaveSingleUrlTest
extends QueueMasterSlaveTestSupport {
    private final String brokerUrl = "tcp://localhost:62001";
    private final String singleUriString = "failover://(tcp://localhost:62001)?randomize=false&useExponentialBackOff=false";

    @Override
    protected void setUp() throws Exception {
        this.setAutoFail(true);
        super.setUp();
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("failover://(tcp://localhost:62001)?randomize=false&useExponentialBackOff=false");
    }

    @Override
    protected void createMaster() throws Exception {
        this.master = new BrokerService();
        this.master.setBrokerName("shared-master");
        this.configureSharedPersistenceAdapter(this.master);
        this.master.addConnector("tcp://localhost:62001");
        this.master.start();
    }

    private void configureSharedPersistenceAdapter(BrokerService broker) throws Exception {
        LevelDBStore adapter = new LevelDBStore();
        adapter.setDirectory(new File("shared"));
        broker.setPersistenceAdapter((PersistenceAdapter)adapter);
    }

    @Override
    protected void createSlave() throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BrokerService broker = new BrokerService();
                    broker.setBrokerName("shared-slave");
                    QueueMasterSlaveSingleUrlTest.this.configureSharedPersistenceAdapter(broker);
                    TransportConnector tConnector = new TransportConnector();
                    tConnector.setUri(new URI("tcp://localhost:62001"));
                    broker.addConnector(tConnector);
                    broker.start();
                    QueueMasterSlaveSingleUrlTest.this.slave.set(broker);
                    QueueMasterSlaveSingleUrlTest.this.slaveStarted.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void testNetworkMasterSlave() throws Exception {
        final BrokerService client = new BrokerService();
        client.setBrokerName("client");
        client.setPersistent(false);
        client.getManagementContext().setCreateConnector(false);
        client.addNetworkConnector("masterslave:(tcp://localhost:62001,tcp://localhost:62002)");
        client.start();
        try {
            Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return client.getRegionBroker().getPeerBrokerInfos().length == 1;
                }
            });
            QueueMasterSlaveSingleUrlTest.assertTrue((!this.master.isSlave() ? 1 : 0) != 0);
            this.master.stop();
            QueueMasterSlaveSingleUrlTest.assertTrue((String)"slave started", (boolean)this.slaveStarted.await(60L, TimeUnit.SECONDS));
            QueueMasterSlaveSingleUrlTest.assertTrue((!((BrokerService)this.slave.get()).isSlave() ? 1 : 0) != 0);
            Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return client.getRegionBroker().getPeerBrokerInfos().length == 1;
                }
            });
        }
        finally {
            client.stop();
        }
    }
}

