/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Enumeration;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4487Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ4487Test.class);
    private final String destinationName = "TEST.QUEUE";
    private BrokerService broker;
    private ActiveMQConnectionFactory factory;

    @Before
    public void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.deleteAllMessages();
        this.broker.setUseJmx(false);
        this.broker.setAdvisorySupport(false);
        PolicyEntry policy = new PolicyEntry();
        policy.setQueue(">");
        policy.setMaxProducersToAudit(75);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        this.broker.setDestinationPolicy(pMap);
        this.broker.start();
        this.broker.waitUntilStarted();
        this.factory = new ActiveMQConnectionFactory("vm://localhost");
    }

    @After
    public void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    private void sendMessages(int messageToSend) throws Exception {
        String data = "";
        for (int i = 0; i < 2048; ++i) {
            data = data + "x";
        }
        Connection connection = this.factory.createConnection();
        connection.start();
        for (int i = 0; i < messageToSend; ++i) {
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue("TEST.QUEUE");
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage(data));
            session.close();
        }
        connection.close();
    }

    @Test
    public void testBrowsingWithLessThanMaxAuditDepth() throws Exception {
        this.doTestBrowsing(75);
    }

    @Test
    public void testBrowsingWithMoreThanMaxAuditDepth() throws Exception {
        this.doTestBrowsing(300);
    }

    private void doTestBrowsing(int messagesToSend) throws Exception {
        Connection connection = this.factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("TEST.QUEUE");
        this.sendMessages(messagesToSend);
        QueueBrowser browser = session.createBrowser(queue);
        Enumeration enumeration = browser.getEnumeration();
        int received = 0;
        while (enumeration.hasMoreElements()) {
            Message m = (Message)enumeration.nextElement();
            Assert.assertNotNull((Object)m);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Browsed Message: {}", (Object)m.getJMSMessageID());
            }
            if (++received <= messagesToSend) continue;
            break;
        }
        browser.close();
        Assert.assertEquals((long)messagesToSend, (long)received);
    }
}

