/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TextMessage;
import javax.jms.XASession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQXAConnection;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerRestartTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.TransactionBroker;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4950Test
extends BrokerRestartTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(AMQ4950Test.class);
    protected static final String simulatedExceptionMessage = "Simulating error inside tx prepare().";
    public boolean prioritySupport = false;
    protected String connectionUri = null;

    @Override
    protected void configureBroker(BrokerService broker) throws Exception {
        broker.setDestinationPolicy(this.policyMap);
        broker.setDeleteAllMessagesOnStartup(true);
        broker.setUseJmx(false);
        this.connectionUri = broker.addConnector("tcp://localhost:0").getPublishableConnectString();
        broker.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){

            public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
                this.getNext().prepareTransaction(context, xid);
                LOG.debug("BrokerPlugin.prepareTransaction() will throw an exception.");
                throw new XAException(AMQ4950Test.simulatedExceptionMessage);
            }

            public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
                LOG.debug("BrokerPlugin.commitTransaction().");
                super.commitTransaction(context, xid, onePhase);
            }
        }});
    }

    public void testXAPrepareFailure() throws Exception {
        AMQ4950Test.assertNotNull((Object)this.connectionUri);
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("failover:(" + this.connectionUri + ")");
        ActiveMQXAConnection xaConnection = (ActiveMQXAConnection)cf.createConnection();
        xaConnection.start();
        XASession session = xaConnection.createXASession();
        XAResource resource = session.getXAResource();
        Xid tid = this.createXid();
        resource.start(tid, 0);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(((Object)((Object)this)).getClass().getName()));
        TextMessage message = session.createTextMessage("Sample Message");
        producer.send((Message)message);
        resource.end(tid, 0x4000000);
        try {
            LOG.debug("Calling XA prepare(), expecting an exception");
            int ret = resource.prepare(tid);
            if (0 == ret) {
                resource.commit(tid, false);
            }
        }
        catch (XAException xae) {
            LOG.info("Received excpected XAException: {}", (Object)xae.getMessage());
            LOG.info("Rolling back transaction {}", (Object)tid);
            AMQ4950Test.assertEquals((String)simulatedExceptionMessage, (String)xae.getMessage());
            resource.rollback(tid);
        }
        this.assertTransactionGoneFromBroker(tid);
        this.assertTransactionGoneFromConnection(this.broker.getBrokerName(), xaConnection.getClientID(), xaConnection.getConnectionInfo().getConnectionId(), tid);
        this.assertTransactionGoneFromFailoverState(xaConnection, tid);
        producer.close();
        session.close();
        xaConnection.close();
        LOG.debug("testXAPrepareFailure() finished.");
    }

    public Xid createXid() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        os.writeLong(++this.txGenerator);
        os.close();
        final byte[] bs = baos.toByteArray();
        return new Xid(){

            @Override
            public int getFormatId() {
                return 86;
            }

            @Override
            public byte[] getGlobalTransactionId() {
                return bs;
            }

            @Override
            public byte[] getBranchQualifier() {
                return bs;
            }
        };
    }

    private void assertTransactionGoneFromFailoverState(ActiveMQXAConnection connection1, Xid tid) throws Exception {
        FailoverTransport transport = (FailoverTransport)connection1.getTransport().narrow(FailoverTransport.class);
        TransactionInfo info = new TransactionInfo(connection1.getConnectionInfo().getConnectionId(), (TransactionId)new XATransactionId(tid), 2);
        AMQ4950Test.assertNull((String)"transaction should not exist in the state tracker", (Object)transport.getStateTracker().processCommitTransactionOnePhase(info));
    }

    private void assertTransactionGoneFromBroker(Xid tid) throws Exception {
        BrokerService broker = BrokerRegistry.getInstance().lookup("localhost");
        TransactionBroker transactionBroker = (TransactionBroker)broker.getBroker().getAdaptor(TransactionBroker.class);
        try {
            transactionBroker.getTransaction(null, (TransactionId)new XATransactionId(tid), false);
            AMQ4950Test.fail((String)"expected exception on tx not found");
        }
        catch (XAException xAException) {
            // empty catch block
        }
    }

    private void assertTransactionGoneFromConnection(String brokerName, String clientId, ConnectionId connectionId, Xid tid) throws Exception {
        BrokerService broker = BrokerRegistry.getInstance().lookup(brokerName);
        CopyOnWriteArrayList connections = ((TransportConnector)broker.getTransportConnectors().get(0)).getConnections();
        for (TransportConnection connection : connections) {
            if (!connection.getConnectionId().equals(clientId)) continue;
            try {
                connection.processPrepareTransaction(new TransactionInfo(connectionId, (TransactionId)new XATransactionId(tid), 1));
                AMQ4950Test.fail((String)"did not get expected excepton on missing transaction, it must be still there in error!");
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }
}

