/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.ConstantPendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ6579Test {
    protected BrokerService brokerService;
    protected Connection connection;
    protected Session session;
    protected ActiveMQTopic topic;
    protected org.apache.activemq.broker.region.Destination amqDestination;
    protected MessageConsumer consumer;

    @Before
    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        PolicyEntry policy = new PolicyEntry();
        policy.setTopicPrefetch(5);
        ConstantPendingMessageLimitStrategy pendingMessageLimitStrategy = new ConstantPendingMessageLimitStrategy();
        pendingMessageLimitStrategy.setLimit(5);
        policy.setPendingMessageLimitStrategy((PendingMessageLimitStrategy)pendingMessageLimitStrategy);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        this.brokerService.setDestinationPolicy(pMap);
        TransportConnector tcp = this.brokerService.addConnector("tcp://localhost:0");
        this.brokerService.start();
        this.connection = new ActiveMQConnectionFactory(tcp.getPublishableConnectString()).createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.topic = new ActiveMQTopic("test.topic");
        this.consumer = this.session.createConsumer((Destination)this.topic);
        this.amqDestination = TestSupport.getDestination(this.brokerService, (ActiveMQDestination)this.topic);
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.brokerService.stop();
    }

    @Test(timeout=10000L)
    public void testExpireWithPendingLimitStrategy() throws Exception {
        this.sendMessages(5, 0);
        this.sendMessages(5, 1);
        this.sendMessages(5, 0);
        Assert.assertEquals((long)10L, (long)this.receiveMessages());
    }

    protected void sendMessages(int count, int expire) throws JMSException {
        MessageProducer producer = this.session.createProducer((Destination)this.topic);
        producer.setTimeToLive((long)expire);
        for (int i = 0; i < count; ++i) {
            TextMessage textMessage = this.session.createTextMessage("test");
            producer.send((Message)textMessage);
        }
    }

    protected int receiveMessages() throws JMSException {
        int count = 0;
        while (this.consumer.receive(500L) != null) {
            ++count;
        }
        return count;
    }
}

