/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jmx;

import javax.management.ObjectName;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.NetworkConnectorViewMBean;
import org.junit.Assert;
import org.junit.Test;

public class JmxCreateNCTest {
    private static final String BROKER_NAME = "jmx-broker";

    @Test
    public void testBridgeRegistration() throws Exception {
        System.setProperty("org.apache.activemq.audit", "all");
        BrokerService broker = new BrokerService();
        broker.setBrokerName(BROKER_NAME);
        broker.setUseJmx(true);
        broker.start();
        broker.waitUntilStarted();
        ObjectName brokerObjectName = new ObjectName("org.apache.activemq:type=Broker,brokerName=jmx-broker");
        BrokerViewMBean proxy = (BrokerViewMBean)broker.getManagementContext().newProxyInstance(brokerObjectName, BrokerViewMBean.class, true);
        Assert.assertNotNull((String)"We could not retrieve the broker from JMX", (Object)proxy);
        String connectoName = proxy.addNetworkConnector("static:(tcp://localhost:61617)");
        Assert.assertEquals((Object)"NC", (Object)connectoName);
        ObjectName networkConnectorObjectName = new ObjectName("org.apache.activemq:type=Broker,brokerName=jmx-broker,connector=networkConnectors,networkConnectorName=" + connectoName);
        NetworkConnectorViewMBean nc = (NetworkConnectorViewMBean)broker.getManagementContext().newProxyInstance(networkConnectorObjectName, NetworkConnectorViewMBean.class, true);
        Assert.assertNotNull((Object)nc);
        Assert.assertEquals((Object)"NC", (Object)nc.getName());
    }
}

